/**
 * Copyright (c) 2007, 2009, 2013, 2021 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 * Alexander Shatalin (Borland) - initial API and implementation
 * Michael Golubev (Montages) - #386838 - migrate to Xtend2
 * Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : 1.4 Merge papyrus extension templates into codegen.xtend
 * Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : L1.2 clean up
 */
package xpt.editor;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenApplication;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import xpt.CodeStyle;
import xpt.Common;

@Singleton
@SuppressWarnings("all")
public class ResourceSetModificationListener {
  @Inject
  @Extension
  private CodeStyle _codeStyle;

  @Inject
  @Extension
  private Common _common;

  public CharSequence extendsList(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("extends org.eclipse.emf.ecore.util.EContentAdapter");
    return _builder;
  }

  /**
   * Inner class of DocumentProvider
   */
  public CharSequence ResourceSetModificationListener(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.append("\t");
    _builder.newLineIfNotEmpty();
    _builder.append("private class ResourceSetModificationListener ");
    CharSequence _extendsList = this.extendsList(it);
    _builder.append(_extendsList);
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _attributes = this.attributes(it);
    _builder.append(_attributes, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _constructor = this.constructor(it);
    _builder.append(_constructor, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _notifyChanged = this.notifyChanged(it);
    _builder.append(_notifyChanged, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence attributes(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.append("\t");
    _builder.newLineIfNotEmpty();
    _builder.append("private org.eclipse.emf.transaction.NotificationFilter myModifiedFilter;");
    _builder.newLine();
    _builder.newLine();
    CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_1);
    _builder.append("\t");
    _builder.newLineIfNotEmpty();
    _builder.append("private ResourceSetInfo myInfo;");
    _builder.newLine();
    return _builder;
  }

  public CharSequence constructor(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.append("\t");
    _builder.newLineIfNotEmpty();
    _builder.append("public ResourceSetModificationListener(ResourceSetInfo info) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("myInfo = info;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("myModifiedFilter = org.eclipse.emf.transaction.NotificationFilter.createEventTypeFilter(org.eclipse.emf.common.notify.Notification.SET).or(org.eclipse.emf.transaction.NotificationFilter.createEventTypeFilter(org.eclipse.emf.common.notify.Notification.UNSET)).and(org.eclipse.emf.transaction.NotificationFilter.createFeatureFilter(org.eclipse.emf.ecore.resource.Resource.class, org.eclipse.emf.ecore.resource.Resource.RESOURCE__IS_MODIFIED));");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence notifyChanged(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideC = this._codeStyle.overrideC(it);
    _builder.append(_overrideC);
    _builder.newLineIfNotEmpty();
    _builder.append("public void notifyChanged(org.eclipse.emf.common.notify.Notification notification) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (notification.getNotifier() instanceof org.eclipse.emf.ecore.resource.ResourceSet) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("super.notifyChanged(notification);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (!notification.isTouch() && myModifiedFilter.matches(notification)) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (notification.getNotifier() instanceof org.eclipse.emf.ecore.resource.Resource) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("org.eclipse.emf.ecore.resource.Resource resource = (org.eclipse.emf.ecore.resource.Resource) notification.getNotifier();");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if (resource.isLoaded()) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("boolean modified = false;");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("for (java.util.Iterator<org.eclipse.emf.ecore.resource.Resource> it = myInfo.getLoadedResourcesIterator(); it.hasNext() && !modified;) {");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("org.eclipse.emf.ecore.resource.Resource nextResource = it.next();");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("if (nextResource.isLoaded()) {");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t");
    _builder.append("modified = nextResource.isModified();");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("boolean dirtyStateChanged = false;");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("synchronized (myInfo) {");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("if (modified != myInfo.fCanBeSaved) {");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t");
    _builder.append("myInfo.fCanBeSaved = modified;");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t");
    _builder.append("dirtyStateChanged = true;");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("}");
    _builder.newLine();
    {
      GenApplication _application = it.getEditorGen().getApplication();
      boolean _tripleEquals = (null == _application);
      if (_tripleEquals) {
        _builder.append("\t\t\t\t\t");
        _builder.append("if (!resource.isModified()) {");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("\t");
        _builder.append("myInfo.setSynchronized(resource);");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("}");
        _builder.newLine();
      }
    }
    _builder.append("\t\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("if (dirtyStateChanged) {");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("fireElementDirtyStateChanged(myInfo.getEditorInput(), modified);");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("if (!modified) {");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t");
    _builder.append("myInfo.setModificationStamp(computeModificationStamp(myInfo));");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
}
