/**
 * Copyright (c) 2006, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 * 	Anna Karjakina (Borland) - initial API and implementation
 * 	Michael Golubev (Montages) - #386838 - migrate to Xtend2
 * 	Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package xpt;

import com.google.inject.Singleton;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenEditorGenerator;
import org.eclipse.papyrus.gmf.codegen.xtend.annotations.MetaDef;

@Singleton
@SuppressWarnings("all")
public class ExternalizerUtils_qvto {
  @MetaDef
  public String getExternalizerPackageName(final GenEditorGenerator generator) {
    return generator.getEditor().getPackageName();
  }

  @MetaDef
  public String getExternalizerClassName() {
    return "Messages";
  }

  public String escapeIllegalKeySymbols(final String key) {
    return key.replaceAll("[=&\"]", "").replaceAll("[ .]", "_");
  }

  public String escapeIllegalMessageSymbols(final String message) {
    return message.replaceAll("!", "\\\\!");
  }

  public String titleKey(final String dialogKey) {
    return (dialogKey + "Title");
  }

  public String messageKey(final String dialogKey) {
    return (dialogKey + "Message");
  }

  public String nameKey(final String dialogKey) {
    return (dialogKey + "Name");
  }

  public String descriptionKey(final String dialogKey) {
    return (dialogKey + "Description");
  }
}
