/**
 * Copyright (c) 2007, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Alexander Shatalin (Borland) - initial API and implementation
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package diagram.editpolicies;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import impl.diagram.update.CanonicalUpdate;
import impl.diagram.update.domain2notation;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLink;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import xpt.Common;
import xpt.Common_qvto;

@Singleton
@SuppressWarnings("all")
public class DiagramCanonicalEditPolicy {
  @Inject
  @Extension
  private Common _common;

  @Inject
  @Extension
  private Common_qvto _common_qvto;

  @Inject
  private CanonicalUpdate xptCanonicalUpdate;

  @Inject
  private domain2notation xptDomain2notation;

  public CharSequence className(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    String _canonicalEditPolicyClassName = it.getCanonicalEditPolicyClassName();
    _builder.append(_canonicalEditPolicyClassName);
    return _builder;
  }

  public CharSequence packageName(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    String _editPoliciesPackageName = it.getEditPoliciesPackageName();
    _builder.append(_editPoliciesPackageName);
    return _builder;
  }

  public CharSequence qualifiedClassName(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(".");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    return _builder;
  }

  public CharSequence fullPath(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }

  public CharSequence extendsList(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("extends org.eclipse.gmf.runtime.diagram.ui.editpolicies.CanonicalEditPolicy");
    return _builder;
  }

  public CharSequence Main(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _copyright = this._common.copyright(it.getEditorGen());
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("package ");
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public class ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append(" ");
    CharSequence _extendsList = this.extendsList(it);
    _builder.append(_extendsList);
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _body = this.xptCanonicalUpdate.body(it);
    _builder.append(_body, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _refreshSemanticMethod = this.refreshSemanticMethod(it);
    _builder.append(_refreshSemanticMethod, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _refreshLinks = this.refreshLinks(it);
    _builder.append(_refreshLinks, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _DomainToNotationClass = this.xptDomain2notation.DomainToNotationClass(it);
    _builder.append(_DomainToNotationClass, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _additions = this.additions(it);
    _builder.append(_additions, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence refreshSemanticMethod(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected void refreshSemantic() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (resolveSemanticElement() == null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("java.util.LinkedList<org.eclipse.core.runtime.IAdaptable> createdViews = new java.util.LinkedList<org.eclipse.core.runtime.IAdaptable>();");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _refreshSemanticChildren = this.xptCanonicalUpdate.refreshSemanticChildren(it, "createdViews", it.getEditorGen().getDiagramUpdater());
    _builder.append(_refreshSemanticChildren, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    {
      boolean _notEmpty = this._common_qvto.<GenLink>notEmpty(it.getLinks());
      if (_notEmpty) {
        _builder.append("\t");
        _builder.append("java.util.Collection<org.eclipse.core.runtime.IAdaptable> createdConnectionViews = refreshConnections();");
        _builder.newLine();
      }
    }
    _builder.newLine();
    _builder.append("\t");
    CharSequence _executeLayoutCommand = this.xptCanonicalUpdate.executeLayoutCommand(it, "createdViews");
    _builder.append(_executeLayoutCommand, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    {
      boolean _notEmpty_1 = this._common_qvto.<GenLink>notEmpty(it.getLinks());
      if (_notEmpty_1) {
        _builder.append("\t");
        _builder.append("createdViews.addAll(createdConnectionViews);");
        _builder.newLine();
      }
    }
    _builder.newLine();
    _builder.append("\t");
    _builder.append("makeViewsImmutable(createdViews);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence refreshLinks(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _notEmpty = this._common_qvto.<GenLink>notEmpty(it.getLinks());
      if (_notEmpty) {
        CharSequence _refreshConnectionsMethod = this.refreshConnectionsMethod(it);
        _builder.append(_refreshConnectionsMethod);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _refreshConnectionsAuxMethods = this.xptCanonicalUpdate.refreshConnectionsAuxMethods(it);
        _builder.append(_refreshConnectionsAuxMethods);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }

  public CharSequence refreshConnectionsMethod(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private java.util.Collection<org.eclipse.core.runtime.IAdaptable> refreshConnections() {");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _refreshConnectionsBody = this.xptCanonicalUpdate.refreshConnectionsBody(it);
    _builder.append(_refreshConnectionsBody, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence additions(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
}
