/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.properties.toolsmiths.preferences;

import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.function.Predicate;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.util.Policy;
import org.eclipse.papyrus.views.properties.toolsmiths.Activator;
import org.eclipse.papyrus.views.properties.toolsmiths.messages.Messages;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.WorkbenchException;

public enum CustomizationEditorActionKind {
    NOTHING("Do nothing"),
    PERSPECTIVE("Open the customization perspective"),
    PREVIEW("Open the customization preview view"),
    PROMPT("Ask what to do");

    private final String label;

    private CustomizationEditorActionKind(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public void perform(IWorkbenchPage workbenchPage) {
        IPerspectiveDescriptor perspective = workbenchPage.getPerspective();
        if (perspective != null && "org.eclipse.papyrus.customization.properties.perspective".equals(perspective.getId())) {
            return;
        }
        switch (this) {
            case PERSPECTIVE: {
                try {
                    workbenchPage.getWorkbenchWindow().getWorkbench().showPerspective("org.eclipse.papyrus.customization.properties.perspective", workbenchPage.getWorkbenchWindow());
                }
                catch (WorkbenchException e) {
                    Policy.getStatusHandler().show(e.getStatus(), Messages.CustomizationEditorActionKind_0);
                }
                break;
            }
            case PREVIEW: {
                try {
                    workbenchPage.showView("org.eclipse.papyrus.customization.properties.preview");
                }
                catch (PartInitException e) {
                    Policy.getStatusHandler().show(e.getStatus(), Messages.CustomizationEditorActionKind_1);
                }
                break;
            }
            case PROMPT: {
                CustomizationEditorActionKind.prompt(workbenchPage);
                break;
            }
        }
    }

    public static CustomizationEditorActionKind getOnOpenCustomizationEditorAction() {
        String pref = Optional.ofNullable(Activator.getDefault().getPreferenceStore().getString("onOpenCustomizationEditor")).filter(Predicate.not(String::isBlank)).orElse(CustomizationEditorActionKind.getDefault().name());
        return CustomizationEditorActionKind.valueOf(pref);
    }

    public static CustomizationEditorActionKind getDefault() {
        return PROMPT;
    }

    private static void prompt(IWorkbenchPage workbenchPage) {
        String toggleMessage = Messages.CustomizationEditorActionKind_2;
        LinkedHashMap buttons = new LinkedHashMap();
        EnumSet.complementOf(EnumSet.of(PROMPT)).forEach(v -> {
            Integer n = buttons.put(v.getLabel(), v.toButtonCode());
        });
        MessageDialogWithToggle dialog = new MessageDialogWithToggle(workbenchPage.getWorkbenchWindow().getShell(), Messages.CustomizationEditorActionKind_3, null, Messages.CustomizationEditorActionKind_4, 3, buttons, PREVIEW.ordinal(), toggleMessage, false);
        CustomizationEditorActionKind.forButtonCode(dialog.open()).ifPresent(result -> {
            result.perform(workbenchPage);
            if (dialog.getToggleState()) {
                Activator.getDefault().getPreferenceStore().setValue("onOpenCustomizationEditor", result.name());
            }
        });
    }

    int toButtonCode() {
        return this.ordinal() + 2;
    }

    static Optional<CustomizationEditorActionKind> forButtonCode(int code) {
        return code < 2 ? Optional.empty() : Optional.of(CustomizationEditorActionKind.values()[code - 2]);
    }
}

