/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.uml.diagram.common.core.services;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.uml.domain.services.IViewQuerier;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.model.business.internal.query.DNodeContainerExperimentalQuery;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;

public class RepresentationQuerier
implements IViewQuerier {
    private Object diagram;

    public RepresentationQuerier(Object diagram) {
        this.diagram = diagram;
    }

    public Object getVisualParent(Object element) {
        EObject parent = null;
        if (element instanceof DSemanticDecorator) {
            parent = ((DSemanticDecorator)element).eContainer();
            if (element instanceof DNodeContainer && parent instanceof DNodeContainer && new DNodeContainerExperimentalQuery((DNodeContainer)parent).isRegionContainer()) {
                parent = parent.eContainer();
            }
        }
        return parent;
    }

    public EObject getSemanticElement(Object view) {
        if (view instanceof DSemanticDecorator) {
            DSemanticDecorator semanticDecorator = (DSemanticDecorator)view;
            return semanticDecorator.getTarget();
        }
        return null;
    }

    public List<? extends Object> getVisualAncestorNodes(Object view) {
        ArrayList<EObject> parents = new ArrayList<EObject>();
        if (view instanceof DSemanticDecorator) {
            DSemanticDecorator semanticDecorator = (DSemanticDecorator)view;
            EObject parent = semanticDecorator.eContainer();
            while (parent != null) {
                parents.add(parent);
                parent = parent.eContainer();
            }
        }
        return parents;
    }

    public List<? extends Object> getChildrenNodes(Object view) {
        if (view instanceof DNodeContainer) {
            DNodeContainer node = (DNodeContainer)view;
            return node.getNodes();
        }
        return Collections.emptyList();
    }

    public List<? extends Object> getBorderedNodes(Object view) {
        if (view instanceof DNodeContainer) {
            DNodeContainer node = (DNodeContainer)view;
            return node.getOwnedBorderedNodes();
        }
        return Collections.emptyList();
    }

    public Object getDiagram() {
        return this.diagram;
    }
}

