/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.architecture.handlers;

import java.util.Arrays;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.architecture.ArchitectureDescriptionUtils;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.ui.architecture.dialogs.ArchitectureContextDialog;
import org.eclipse.papyrus.infra.ui.architecture.messages.Messages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class ChangeArchitectureContextHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        EObject selection = this.getSelection(event);
        if (selection == null) {
            return new IContributionItem[0];
        }
        ResourceSet resourceSet = selection.eResource().getResourceSet();
        if (!(resourceSet instanceof ModelSet)) {
            return new IContributionItem[0];
        }
        ArchitectureDescriptionUtils helper = new ArchitectureDescriptionUtils((ModelSet)resourceSet);
        Object[] contextIds = new String[]{helper.getArchitectureContextId()};
        Object[] viewpointIds = helper.getArchitectureViewpointIds().toArray(new String[0]);
        Shell shell = Display.getCurrent().getActiveShell();
        ArchitectureContextDialog dialog = new ArchitectureContextDialog(shell, Messages.ChangeArchitectureContextHandler_dialogTitle, Messages.ChangeArchitectureContextHandler_dialogLabel);
        dialog.setSelectedContexts((String[])contextIds);
        dialog.setSelectedViewpoints((String[])viewpointIds);
        dialog.create();
        if (dialog.open() == 0) {
            TransactionalEditingDomain dom = helper.getModelSet().getTransactionalEditingDomain();
            CompoundCommand cmd = new CompoundCommand("Change Architecture Context");
            if (!Arrays.equals(dialog.getSelectedContextIds(), contextIds)) {
                cmd.append(helper.switchArchitectureContextId(dialog.getSelectedContextIds()[0]));
            }
            if (!Arrays.equals(dialog.getSelectedViewpointIds(), viewpointIds)) {
                cmd.append(helper.switchArchitectureViewpointIds(dialog.getSelectedViewpointIds()));
            }
            if (!cmd.isEmpty()) {
                dom.getCommandStack().execute((Command)cmd);
            }
        }
        return null;
    }

    protected EObject getSelection(ExecutionEvent event) {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection struct = (IStructuredSelection)selection;
            Object obj = struct.getFirstElement();
            return EMFHelper.getEObject((Object)obj);
        }
        return null;
    }
}

