/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.export.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.jdt.internal.ui.util.TableLayoutComposite;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.papyrus.uml.export.Activator;
import org.eclipse.papyrus.uml.export.extension.HTMLExtensionRegistry;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class HTMLExportPreferencesPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String ACTIVE_STRATEGIES = "active.strategy";
    public static final String INACTIVE_STRATEGIES = "inactive.strategy";
    private Label fFilterViewerLabel;
    private Table fFilterTable;
    private CheckboxTableViewer fFilterViewer;
    private TableEditor fTableEditor;
    private IdentifiedEntryStructuredContentProvider fStackFilterContentProvider;

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        this.createStackFilterPreferences(composite);
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void createStackFilterPreferences(Composite composite) {
        this.fFilterViewerLabel = new Label(composite, 16388);
        this.fFilterViewerLabel.setText("Available strategies to enhance default generation");
        Composite container = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        container.setLayoutData((Object)gd);
        this.createFilterTable(container);
    }

    private void createFilterTable(Composite container) {
        TableLayoutComposite layouter = new TableLayoutComposite(container, 0);
        layouter.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        layouter.setLayoutData((Object)new GridData(1808));
        this.fFilterTable = new Table((Composite)layouter, 67618);
        TableColumn tableColumn = new TableColumn(this.fFilterTable, 0);
        this.fFilterViewer = new CheckboxTableViewer(this.fFilterTable);
        this.fStackFilterContentProvider = new IdentifiedEntryStructuredContentProvider();
        this.fFilterViewer.setLabelProvider((IBaseLabelProvider)new MyFilterLabelProvider());
        this.fFilterViewer.setComparator((ViewerComparator)new MyFilterViewerSorter());
        this.fFilterViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                IdentifiedEntry filter = (IdentifiedEntry)event.getElement();
                HTMLExportPreferencesPage.this.fStackFilterContentProvider.toggleFilter(filter);
            }
        });
        this.fFilterViewer.setContentProvider((IContentProvider)this.fStackFilterContentProvider);
        this.fFilterViewer.setInput((Object)this);
        this.fStackFilterContentProvider.refresh();
    }

    public boolean performOk() {
        this.fStackFilterContentProvider.saveFilters();
        return true;
    }

    private static class IdentifiedEntry {
        private String id;
        private String label;
        private boolean checked;

        public IdentifiedEntry(String id, String label, boolean checked) {
            this.id = id;
            this.label = label;
            this.setChecked(checked);
        }

        public String getLabel() {
            return this.label;
        }

        public String getId() {
            return this.id;
        }

        public boolean isChecked() {
            return this.checked;
        }

        public void setChecked(boolean checked) {
            this.checked = checked;
        }

        public boolean equals(Object o) {
            if (!(o instanceof IdentifiedEntry)) {
                return false;
            }
            IdentifiedEntry other = (IdentifiedEntry)o;
            return this.getLabel().equals(other.getLabel());
        }

        public int hashCode() {
            return this.id.hashCode();
        }
    }

    private class IdentifiedEntryStructuredContentProvider
    implements IStructuredContentProvider {
        private List<IdentifiedEntry> fFilters;

        public IdentifiedEntryStructuredContentProvider() {
            HashMap<String, String> active = new HashMap<String, String>();
            HashMap<String, String> inactive = new HashMap<String, String>();
            List<String> activeStrategies = this.parseList(Activator.getDefault().getPreferenceStore().getString(HTMLExportPreferencesPage.ACTIVE_STRATEGIES));
            List<String> inactiveStrategies = this.parseList(Activator.getDefault().getPreferenceStore().getString(HTMLExportPreferencesPage.INACTIVE_STRATEGIES));
            List<IExtension> allExtension = HTMLExtensionRegistry.getInstance().getAllExtension();
            for (IExtension iExtension : allExtension) {
                String uniqueIdentifier = iExtension.getUniqueIdentifier();
                if (inactiveStrategies.contains(uniqueIdentifier)) {
                    inactive.put(uniqueIdentifier, iExtension.getLabel());
                    continue;
                }
                if (activeStrategies.contains(uniqueIdentifier)) {
                    active.put(uniqueIdentifier, iExtension.getLabel());
                    continue;
                }
                active.put(uniqueIdentifier, iExtension.getLabel());
            }
            this.populateFilters(active, inactive);
        }

        public void setDefaults() {
            HTMLExportPreferencesPage.this.fFilterViewer.remove(this.fFilters.toArray());
            HashMap<String, String> active = new HashMap<String, String>();
            HashMap<String, String> inactive = new HashMap<String, String>();
            this.populateFilters(active, inactive);
        }

        protected void populateFilters(Map<String, String> activeList, Map<String, String> inactiveList) {
            this.fFilters = new ArrayList<IdentifiedEntry>(activeList.size() + inactiveList.size());
            this.populateList(activeList, true);
            if (!inactiveList.isEmpty()) {
                this.populateList(inactiveList, false);
            }
        }

        protected void populateList(Map<String, String> list, boolean checked) {
            for (Map.Entry<String, String> entry : list.entrySet()) {
                this.addFilter(entry.getKey(), entry.getValue(), checked);
            }
        }

        public IdentifiedEntry addFilter(String id, String name, boolean checked) {
            IdentifiedEntry filter = new IdentifiedEntry(id, name, checked);
            if (!this.fFilters.contains(filter)) {
                this.fFilters.add(filter);
                HTMLExportPreferencesPage.this.fFilterViewer.add((Object)filter);
                HTMLExportPreferencesPage.this.fFilterViewer.setChecked((Object)filter, checked);
            }
            return filter;
        }

        public void saveFilters() {
            ArrayList<String> active = new ArrayList<String>(this.fFilters.size());
            ArrayList<String> inactive = new ArrayList<String>(this.fFilters.size());
            for (IdentifiedEntry filter : this.fFilters) {
                String id = filter.getId();
                if (filter.isChecked()) {
                    active.add(id);
                    continue;
                }
                inactive.add(id);
            }
            Activator.getDefault().getPreferenceStore().setValue(HTMLExportPreferencesPage.ACTIVE_STRATEGIES, this.serializeList(active.toArray(new String[active.size()])));
            Activator.getDefault().getPreferenceStore().setValue(HTMLExportPreferencesPage.INACTIVE_STRATEGIES, this.serializeList(inactive.toArray(new String[inactive.size()])));
        }

        public String serializeList(String[] list) {
            if (list == null) {
                return "";
            }
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < list.length) {
                if (i > 0) {
                    buffer.append(',');
                }
                buffer.append(list[i]);
                ++i;
            }
            return buffer.toString();
        }

        public List<String> parseList(String listString) {
            ArrayList<String> list = new ArrayList<String>(10);
            StringTokenizer tokenizer = new StringTokenizer(listString, ",");
            while (tokenizer.hasMoreTokens()) {
                list.add(tokenizer.nextToken());
            }
            return list;
        }

        public void toggleFilter(IdentifiedEntry filter) {
            boolean newState = !filter.isChecked();
            filter.setChecked(newState);
            HTMLExportPreferencesPage.this.fFilterViewer.setChecked((Object)filter, newState);
        }

        public Object[] getElements(Object inputElement) {
            return this.fFilters.toArray();
        }

        public void refresh() {
            for (IdentifiedEntry filter2 : this.fFilters) {
                HTMLExportPreferencesPage.this.fFilterViewer.setChecked((Object)filter2, filter2.isChecked());
            }
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    private static class MyFilterLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private MyFilterLabelProvider() {
        }

        public String getColumnText(Object object, int column) {
            return column == 0 ? this.getText(object) : "";
        }

        public String getText(Object element) {
            return TextProcessor.process((String)((IdentifiedEntry)element).getLabel());
        }

        public Image getColumnImage(Object object, int column) {
            return null;
        }
    }

    private static class MyFilterViewerSorter
    extends ViewerComparator {
        private MyFilterViewerSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            ILabelProvider lprov = (ILabelProvider)((ContentViewer)viewer).getLabelProvider();
            String name1 = lprov.getText(e1);
            String name2 = lprov.getText(e2);
            if (name1 == null) {
                name1 = "";
            }
            if (name2 == null) {
                name2 = "";
            }
            if (name1.length() > 0 && name2.length() > 0) {
                boolean isPackage2;
                boolean isPackage1 = name1.indexOf(42) != -1;
                boolean bl = isPackage2 = name2.indexOf(42) != -1;
                if (isPackage1 && !isPackage2) {
                    return -1;
                }
                if (isPackage2 && !isPackage1) {
                    return 1;
                }
            }
            return this.getComparator().compare(name1, name2);
        }
    }
}

