/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.tree.objects;

import java.util.ArrayList;
import org.eclipse.papyrus.uml.profile.Message;
import org.eclipse.papyrus.uml.profile.tree.ProfileElementLabelProvider;
import org.eclipse.papyrus.uml.profile.tree.objects.AppliedStereotypePropertyTreeObject;
import org.eclipse.papyrus.uml.profile.tree.objects.StereotypedElementTreeObject;
import org.eclipse.papyrus.uml.profile.tree.objects.ValueTreeObject;
import org.eclipse.papyrus.uml.profile.ui.dialogs.ComboSelectionDialog;
import org.eclipse.papyrus.uml.profile.utils.Util;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;

public class MetaclassValueTreeObject
extends ValueTreeObject {
    public MetaclassValueTreeObject(AppliedStereotypePropertyTreeObject parent, Object value) {
        super(parent, value);
        this.value = value;
    }

    @Override
    public void editMe() {
        AppliedStereotypePropertyTreeObject pTO = (AppliedStereotypePropertyTreeObject)this.getParent();
        Element elt = ((StereotypedElementTreeObject)pTO.getParent().getParent()).getElement();
        Property property = pTO.getProperty();
        Type type = property.getType();
        Class<?> metaType = null;
        try {
            metaType = Class.forName("org.eclipse.uml2.uml." + type.getName());
        }
        catch (Exception e) {
            Message.error("No class found with this name : org.eclipse.uml2.uml." + type.getName());
            return;
        }
        ArrayList<Element> filteredElements = Util.getInstancesFilteredByType(elt, metaType, null);
        if (filteredElements.size() <= 0) {
            Message.warning("No element of type " + type.getName() + " found in the model.");
            return;
        }
        pTO.removeSelected(filteredElements, (Element)this.value);
        String[] elementNames = Util.getStringArrayFromList(filteredElements);
        if (elementNames == null) {
            Message.warning("No element of type " + type.getName() + " found in the model.");
            return;
        }
        ProfileElementLabelProvider labelProvider = new ProfileElementLabelProvider();
        String initialValue = this.value != null ? labelProvider.getText(this) : elementNames[0];
        ComboSelectionDialog valueDialog = new ComboSelectionDialog(new Shell(), "New value:", elementNames, initialValue);
        int val = valueDialog.open();
        if (val == 0 && valueDialog.indexOfSelection != -1) {
            Element newValue = filteredElements.get(valueDialog.indexOfSelection);
            pTO.updateValue(pTO.appendMV(newValue));
        }
        valueDialog.close();
    }
}

