/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.types.core.commands;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientReferenceRelationshipRequest;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.tools.utils.ElementUtil;
import org.eclipse.uml2.common.util.CacheAdapter;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.util.UMLUtil;

public class StereotypePropertyReferenceEdgeUtil {
    public static boolean checkNotOrphanStereotypePropertyReferenceEdgeNotYetSet(Edge edge, String stereotypeToSet, String featureToSet, Object newFeatureValue) {
        EAnnotation eAnnotation;
        boolean notOrphan = false;
        if (edge != null && (eAnnotation = edge.getEAnnotation("StereotypePropertyReferenceEdge")) != null) {
            String stereotypeQNAnnotation = (String)eAnnotation.getDetails().get((Object)"stereotypeQualifiedName");
            String featureToSetAnnotation = (String)eAnnotation.getDetails().get((Object)"featureToSet");
            if (stereotypeQNAnnotation != null && featureToSetAnnotation != null) {
                EObject targetElement = edge.getTarget().getElement();
                EObject sourceElement = edge.getSource().getElement();
                if (sourceElement instanceof Element && targetElement instanceof Element && StereotypePropertyReferenceEdgeUtil.checkStereotypePropertyReferenceEdgeSourceCompatibility((Element)sourceElement, stereotypeQNAnnotation)) {
                    notOrphan = featureToSet.equals(featureToSetAnnotation) && stereotypeToSet.equals(stereotypeQNAnnotation) ? StereotypePropertyReferenceEdgeUtil.checkStereotypePropertyReferenceEdgeTargetSet((Element)sourceElement, (Element)targetElement, stereotypeQNAnnotation, featureToSetAnnotation, newFeatureValue) : StereotypePropertyReferenceEdgeUtil.checkStereotypePropertyReferenceEdgeTargetSet((Element)sourceElement, (Element)targetElement, stereotypeQNAnnotation, featureToSetAnnotation);
                }
            }
        }
        return notOrphan;
    }

    public static boolean checkNotOrphanStereotypePropertyReferenceEdge(Edge edge) {
        EAnnotation eAnnotation;
        boolean notOrphan = false;
        if (edge != null && (eAnnotation = edge.getEAnnotation("StereotypePropertyReferenceEdge")) != null) {
            String stereotypeQNAnnotation = (String)eAnnotation.getDetails().get((Object)"stereotypeQualifiedName");
            String featureToSetAnnotation = (String)eAnnotation.getDetails().get((Object)"featureToSet");
            if (stereotypeQNAnnotation != null && featureToSetAnnotation != null) {
                EObject targetElement = edge.getTarget().getElement();
                EObject sourceElement = edge.getSource().getElement();
                if (sourceElement instanceof Element && targetElement instanceof Element && StereotypePropertyReferenceEdgeUtil.checkStereotypePropertyReferenceEdgeSourceCompatibility((Element)sourceElement, stereotypeQNAnnotation)) {
                    notOrphan = StereotypePropertyReferenceEdgeUtil.checkStereotypePropertyReferenceEdgeTargetSet((Element)sourceElement, (Element)targetElement, stereotypeQNAnnotation, featureToSetAnnotation);
                }
            }
        }
        return notOrphan;
    }

    public static boolean checkStereotypePropertyReferenceEdgeTargetSet(Element sourceElement, Element targetElement, String stereotypeQualifiedName, String featureToSet, Object newFeatureValue) {
        Stereotype sourceStereotype;
        Property attribute;
        boolean targetOk = false;
        if (sourceElement != null && targetElement != null && (attribute = (sourceStereotype = sourceElement.getApplicableStereotype(stereotypeQualifiedName)).getAttribute(featureToSet, null)) != null && newFeatureValue != null) {
            Type targetType = attribute.getType();
            Element targetValue = null;
            if (targetType instanceof Stereotype) {
                if (ElementUtil.hasStereotypeApplied((Element)targetElement, (String)targetType.getQualifiedName())) {
                    EObject targetStereotypeApplication = targetElement.getStereotypeApplication(org.eclipse.papyrus.uml.tools.utils.UMLUtil.getAppliedSubstereotype((Element)targetElement, (Stereotype)((Stereotype)targetType)));
                    targetValue = targetStereotypeApplication;
                }
            } else {
                targetValue = targetElement;
            }
            targetOk = newFeatureValue instanceof List ? ((List)newFeatureValue).contains(targetValue) : newFeatureValue.equals(targetValue);
        }
        return targetOk;
    }

    public static boolean checkStereotypePropertyReferenceEdgeTargetSet(Element sourceElement, Element targetElement, String stereotypeQualifiedName, String featureToSet) {
        boolean targetOk = false;
        if (sourceElement != null && targetElement != null) {
            Stereotype sourceStereotype = sourceElement.getApplicableStereotype(stereotypeQualifiedName);
            Stereotype appliedSubstereotype = org.eclipse.papyrus.uml.tools.utils.UMLUtil.getAppliedSubstereotype((Element)sourceElement, (Stereotype)sourceStereotype);
            Object sourceFeatureValue = sourceElement.getValue(appliedSubstereotype, featureToSet);
            Property attribute = sourceStereotype.getAttribute(featureToSet, null);
            if (attribute != null && sourceFeatureValue != null) {
                Type targetType = attribute.getType();
                Element targetValue = null;
                if (targetType instanceof Stereotype) {
                    if (ElementUtil.hasStereotypeApplied((Element)targetElement, (String)targetType.getQualifiedName())) {
                        EObject targetStereotypeApplication = targetElement.getStereotypeApplication(org.eclipse.papyrus.uml.tools.utils.UMLUtil.getAppliedSubstereotype((Element)targetElement, (Stereotype)((Stereotype)targetType)));
                        targetValue = targetStereotypeApplication;
                    }
                } else {
                    targetValue = targetElement;
                }
                targetOk = sourceFeatureValue instanceof List ? ((List)sourceFeatureValue).contains(targetValue) : sourceFeatureValue.equals(targetValue);
            }
        }
        return targetOk;
    }

    public static boolean checkStereotypePropertyReferenceEdgeTargetCompatibility(Element sourceElement, Element targetElement, String stereotypeQualifiedName, String featureToSet) {
        boolean compatible = false;
        if (sourceElement != null && targetElement != null) {
            Stereotype sourceStereotype = sourceElement.getApplicableStereotype(stereotypeQualifiedName);
            Type type = sourceStereotype.getAttribute(featureToSet, null).getType();
            if (type instanceof Stereotype) {
                compatible = ElementUtil.hasStereotypeApplied((Element)targetElement, (String)type.getQualifiedName());
            } else {
                EClassifier metaclass;
                EStructuralFeature eStructuralFeature;
                EObject stereotypeApplication;
                Stereotype appliedSubstereotype = org.eclipse.papyrus.uml.tools.utils.UMLUtil.getAppliedSubstereotype((Element)sourceElement, (Stereotype)sourceStereotype);
                if (appliedSubstereotype != null && (stereotypeApplication = sourceElement.getStereotypeApplication(appliedSubstereotype)) != null && (eStructuralFeature = stereotypeApplication.eClass().getEStructuralFeature(UML2Util.getValidJavaIdentifier((String)featureToSet))) != null && (metaclass = eStructuralFeature.getEType()) instanceof EClassifier) {
                    compatible = metaclass.isInstance((Object)targetElement);
                }
            }
        }
        return compatible;
    }

    public static boolean checkStereotypePropertyReferenceEdgeSourceCompatibility(Element sourceElement, String stereotypeQualifiedName) {
        boolean compatible = false;
        if (sourceElement != null) {
            compatible = ElementUtil.hasStereotypeApplied((Element)sourceElement, (String)stereotypeQualifiedName);
        }
        return compatible;
    }

    public static View findViewFromStereotype(EObject stereotype) {
        View view = null;
        if (stereotype != null) {
            Element baseElement = UMLUtil.getBaseElement((EObject)stereotype);
            view = StereotypePropertyReferenceEdgeUtil.FindViewFromElement(baseElement);
        }
        return view;
    }

    public static View FindViewFromElement(Element element) {
        View view = null;
        if (element != null) {
            Collection settings = CacheAdapter.getInstance().getNonNavigableInverseReferences((EObject)element);
            for (EStructuralFeature.Setting ref : settings) {
                if (!NotationPackage.eINSTANCE.getView_Element().equals(ref.getEStructuralFeature())) continue;
                view = (View)ref.getEObject();
            }
        }
        return view;
    }

    public static ICommand getCleanStereotypePropertyReferenceEdgeCommand(CreateRelationshipRequest request, String stereotypeToSet, String featureToSet) {
        EObject source = request.getSource();
        TransactionalEditingDomain editingDomain = request.getEditingDomain();
        EObject target = request.getTarget();
        return StereotypePropertyReferenceEdgeUtil.getCleanStereotypePropertyReferenceCommand(source, target, stereotypeToSet, featureToSet, editingDomain, null);
    }

    public static ICommand getCleanStereotypePropertyReferenceCommand(EObject source, Object newTargetValue, String stereotypeToSet, String featureToSet, TransactionalEditingDomain editingDomain, Edge movedEdge) {
        Property attribute;
        Stereotype applicableStereotypeToSet;
        Stereotype actualStereotype;
        View view;
        if (source instanceof Element && (view = StereotypePropertyReferenceEdgeUtil.FindViewFromElement((Element)source)) != null && (actualStereotype = org.eclipse.papyrus.uml.tools.utils.UMLUtil.getAppliedSubstereotype((Element)((Element)source), (Stereotype)(applicableStereotypeToSet = ((Element)source).getApplicableStereotype(stereotypeToSet)))) != null && (attribute = applicableStereotypeToSet.getAttribute(featureToSet, null)) != null) {
            Type targetType = attribute.getType();
            Object value = null;
            value = targetType instanceof Stereotype && newTargetValue instanceof Element ? ((Element)newTargetValue).getStereotypeApplication(org.eclipse.papyrus.uml.tools.utils.UMLUtil.getAppliedSubstereotype((Element)((Element)newTargetValue), (Stereotype)actualStereotype)) : newTargetValue;
            String stereotypeQualifiedName = actualStereotype.getQualifiedName();
            if (stereotypeQualifiedName != null && featureToSet != null) {
                CompositeCommand command = new CompositeCommand("Clear stereotype property reference edges");
                for (Object edge : ViewUtil.getSourceConnections((View)view)) {
                    if (!(edge instanceof Edge) || !"StereotypePropertyReferenceEdge".equals(((View)edge).getType()) || movedEdge != null && (movedEdge == null || edge.equals(movedEdge)) || StereotypePropertyReferenceEdgeUtil.checkNotOrphanStereotypePropertyReferenceEdgeNotYetSet((Edge)edge, stereotypeQualifiedName, featureToSet, value)) continue;
                    command.add((IUndoableOperation)new DeleteCommand(editingDomain, (View)((Edge)edge)));
                }
                return command.isEmpty() ? null : command;
            }
        }
        return null;
    }

    public static ICommand getCleanStereotypePropertyReferenceEdgeCommand(ReorientReferenceRelationshipRequest request) {
        int reorientDirection = request.getDirection();
        EObject newEnd = request.getNewRelationshipEnd();
        Object value = request.getParameters().get("graphical_edge");
        Edge view = value instanceof Edge ? (Edge)value : null;
        TransactionalEditingDomain editingDomain = request.getEditingDomain();
        if (view != null) {
            EAnnotation eAnnotation = view.getEAnnotation("StereotypePropertyReferenceEdge");
            String featureToSet = (String)eAnnotation.getDetails().get((Object)"featureToSet");
            String stereotypeToSet = (String)eAnnotation.getDetails().get((Object)"stereotypeQualifiedName");
            EObject target = null;
            if (reorientDirection == 2) {
                target = newEnd;
                CompositeCommand command = new CompositeCommand("Clear stereotype property reference edges");
                for (Object edge : ViewUtil.getSourceConnections((View)view.getSource())) {
                    if (!(edge instanceof Edge) || !"StereotypePropertyReferenceEdge".equals(((View)edge).getType()) || edge.equals(view) || StereotypePropertyReferenceEdgeUtil.checkNotOrphanStereotypePropertyReferenceEdgeNotYetSet((Edge)edge, stereotypeToSet, featureToSet, target)) continue;
                    command.add((IUndoableOperation)new DeleteCommand(editingDomain, (View)((Edge)edge)));
                }
                return command.isEmpty() ? null : command;
            }
        }
        return null;
    }

    public static boolean isStereotypePropertyReferenceEdge(Object object) {
        EAnnotation eAnnotation;
        View view;
        View view2 = view = object instanceof View ? (View)object : null;
        return view != null && (eAnnotation = view.getEAnnotation("StereotypePropertyReferenceEdge")) != null;
    }
}

