/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.types.core.advices.settype;

import java.util.Arrays;
import java.util.Optional;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.infra.properties.contexts.Context;
import org.eclipse.papyrus.infra.properties.contexts.DataContextElement;
import org.eclipse.papyrus.infra.properties.contexts.DataContextRoot;
import org.eclipse.papyrus.infra.properties.ui.modelelement.ModelElement;
import org.eclipse.papyrus.infra.properties.ui.modelelement.ModelElementFactory;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.infra.tools.util.ClassLoaderHelper;
import org.eclipse.papyrus.infra.widgets.creation.ReferenceValueFactory;
import org.eclipse.papyrus.uml.types.core.Activator;
import org.eclipse.papyrus.uml.types.core.advices.settype.SetTypeAdviceConfiguration;
import org.eclipse.papyrus.views.properties.runtime.ConfigurationManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.Element;

public class SetTypeAdviceEditHelperAdvice
extends AbstractEditHelperAdvice {
    protected SetTypeAdviceConfiguration configuration;

    public SetTypeAdviceEditHelperAdvice(SetTypeAdviceConfiguration configuration) {
        this.configuration = configuration;
    }

    public boolean approveRequest(IEditCommandRequest request) {
        return super.approveRequest(request);
    }

    protected ICommand getBeforeConfigureCommand(ConfigureRequest request) {
        return super.getBeforeConfigureCommand(request);
    }

    protected ICommand getAfterConfigureCommand(ConfigureRequest request) {
        if (this.configuration == null) {
            return null;
        }
        AbstractTransactionalCommand resultCommand = null;
        final EObject elementToConfigure = request.getElementToConfigure();
        if (!(elementToConfigure instanceof Element)) {
            return null;
        }
        TransactionalEditingDomain editingDomain = request.getEditingDomain();
        if (editingDomain == null) {
            return null;
        }
        IElementEditService service = ElementEditServiceUtils.getCommandProvider((EObject)elementToConfigure);
        if (service == null) {
            Activator.log.error("Impossible to get edit service from element: " + String.valueOf(elementToConfigure), null);
            return null;
        }
        resultCommand = new AbstractTransactionalCommand(editingDomain, "Editing type", Arrays.asList(WorkspaceSynchronizer.getFile((Resource)elementToConfigure.eResource()))){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                Object elemObject = null;
                Context context = ConfigurationManager.getInstance().getContext("UML");
                if (context != null) {
                    DataContextRoot umlDataContext;
                    Optional<DataContextRoot> umlDataContextFilter = context.getDataContexts().stream().filter(dc -> "UML".equals(dc.getName())).findFirst();
                    DataContextRoot dataContextRoot = umlDataContext = umlDataContextFilter.isPresent() ? umlDataContextFilter.get() : null;
                    if (umlDataContext != null) {
                        String factoryName = umlDataContext.getModelElementFactory().getFactoryClass();
                        ModelElementFactory modelElementFactory = (ModelElementFactory)ClassLoaderHelper.newInstance((String)factoryName, ModelElementFactory.class, (URI)EcoreUtil.getURI((EObject)context));
                        ModelElement umlModelElement = modelElementFactory.createFromSource((Object)elementToConfigure, (DataContextElement)umlDataContext);
                        ReferenceValueFactory factory = umlModelElement.getValueFactory("type");
                        elemObject = factory.edit(Display.getDefault().getFocusControl(), (Object)elementToConfigure);
                    }
                }
                return CommandResult.newOKCommandResult(elemObject);
            }
        };
        return resultCommand;
    }

    protected EObject getDefaultTypeContainer(ConfigureRequest request) {
        if (request.getElementToConfigure() instanceof Element) {
            return ((Element)request.getElementToConfigure()).getNearestPackage();
        }
        return request.getElementToConfigure().eContainer();
    }
}

