/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.drafter.ui.dialog;

import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.uml.internationalization.utils.utils.UMLLabelInternationalization;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;

public class TaggedValuesEditorWidget {
    private Composite contentArea;
    private Stereotype stereotype;
    private NamedElement selectedElement;
    private TreeViewer treeViewer;

    public TaggedValuesEditorWidget(Composite parent, Stereotype stereotype, NamedElement selectedElement) {
        this.stereotype = stereotype;
        this.selectedElement = selectedElement;
        this.createContent(parent);
    }

    public Stereotype getStereotype() {
        return this.stereotype;
    }

    public void setStereotype(Stereotype stereotype) {
        this.stereotype = stereotype;
        this.treeViewer.setInput((Object)stereotype);
    }

    protected void createContent(Composite parent) {
        this.contentArea = this.createContentArea(parent);
        this.treeViewer.setContentProvider((IContentProvider)new MyContentProvider());
        this.treeViewer.setInput((Object)this.stereotype);
    }

    protected Composite createContentArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.makeColumnsEqualWidth = true;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.treeViewer = new TreeViewer(composite, 2048);
        Tree tree = this.treeViewer.getTree();
        tree.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TreeViewerColumn treeViewerColumn = new TreeViewerColumn(this.treeViewer, 0);
        TreeColumn trclmnName = treeViewerColumn.getColumn();
        trclmnName.setWidth(100);
        trclmnName.setText("name");
        treeViewerColumn.setLabelProvider((CellLabelProvider)new TaggedValueNameColumnLabelProvider());
        TreeViewerColumn treeViewerColumn_1 = new TreeViewerColumn(this.treeViewer, 0);
        TreeColumn trclmnType = treeViewerColumn_1.getColumn();
        trclmnType.setWidth(100);
        trclmnType.setText("type");
        treeViewerColumn_1.setLabelProvider((CellLabelProvider)new TaggedValueNameColumnLabelProvider());
        TreeViewerColumn treeViewerColumn_2 = new TreeViewerColumn(this.treeViewer, 0);
        TreeColumn trclmnValue = treeViewerColumn_2.getColumn();
        trclmnValue.setWidth(100);
        trclmnValue.setText("value");
        treeViewerColumn_2.setLabelProvider((CellLabelProvider)new TaggedValueValueColumnLabelProvider());
        return composite;
    }

    private void createDialogContents() {
    }

    private void fillContentArea() {
    }

    private class MyContentProvider
    implements ITreeContentProvider {
        private Object[] EMPTY_ARRAY = new Object[0];

        private MyContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            Stereotype stereotype = (Stereotype)inputElement;
            return stereotype.getAllAttributes().toArray();
        }

        public Object[] getChildren(Object parentElement) {
            return this.EMPTY_ARRAY;
        }

        public Object getParent(Object element) {
            Property property = (Property)element;
            return property.getOwner();
        }

        public boolean hasChildren(Object element) {
            return false;
        }
    }

    public class TaggedValueNameColumnLabelProvider
    extends ColumnLabelProvider {
        public String getText(Object element) {
            Property property = (Property)element;
            return UMLLabelInternationalization.getInstance().getLabel((NamedElement)property);
        }
    }

    public class TaggedValueValueColumnLabelProvider
    extends ColumnLabelProvider {
        public String getText(Object element) {
            Property property = (Property)element;
            Object value = TaggedValuesEditorWidget.this.selectedElement.getValue((Stereotype)property.getOwner(), property.getName());
            if (value instanceof NamedElement) {
                return UMLLabelInternationalization.getInstance().getLabel((NamedElement)value);
            }
            return value.toString();
        }
    }
}

