/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.drafter;

import com.google.common.base.Function;
import org.eclipse.papyrus.uml.internationalization.utils.utils.UMLLabelInternationalization;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.ProfileApplication;
import org.eclipse.uml2.uml.Stereotype;

public class ProfileFunctions {
    public static ProfileFunctions INSTANCE = new ProfileFunctions();
    public static Function<ProfileApplication, Profile> PROFILE_APPLICATION_GETAPPLIEDPROFILE = INSTANCE.new ProfileApplicationProfile();
    public static Function<ProfileApplication, String> PROFILE_APPLICATION_PROFILE_NAME = INSTANCE.new ProfileApplicationProfileName();
    public static Function<ProfileApplication, String> PROFILE_APPLICATION_PROFILE_QUALIFIEDNAME = INSTANCE.new ProfileApplicationProfileQualifiedName();
    public static Function<Stereotype, String> STEROTYPE_NAME = INSTANCE.new StereotypeName();
    public static Function<Stereotype, String> STEROTYPE_QUALIFIEDNAME = INSTANCE.new StereotypeQualifiedName();

    public class ProfileApplicationProfile
    implements Function<ProfileApplication, Profile> {
        public Profile apply(ProfileApplication input) {
            return input.getAppliedProfile();
        }
    }

    public class ProfileApplicationProfileName
    implements Function<ProfileApplication, String> {
        public String apply(ProfileApplication input) {
            return UMLLabelInternationalization.getInstance().getLabel((NamedElement)input.getAppliedProfile());
        }
    }

    public class ProfileApplicationProfileQualifiedName
    implements Function<ProfileApplication, String> {
        public String apply(ProfileApplication input) {
            return input.getAppliedProfile().getQualifiedName();
        }
    }

    public class StereotypeName
    implements Function<Stereotype, String> {
        public String apply(Stereotype input) {
            return UMLLabelInternationalization.getInstance().getKeyword(input);
        }
    }

    public class StereotypeQualifiedName
    implements Function<Stereotype, String> {
        public String apply(Stereotype input) {
            return input.getQualifiedName();
        }
    }
}

