/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.fillhandle.config;

import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.AbstractLayerConfiguration;
import org.eclipse.nebula.widgets.nattable.copy.InternalCellClipboard;
import org.eclipse.nebula.widgets.nattable.copy.command.InternalCopyDataCommandHandler;
import org.eclipse.nebula.widgets.nattable.fillhandle.FillHandleBoundsProvider;
import org.eclipse.nebula.widgets.nattable.fillhandle.FillHandleLayerPainter;
import org.eclipse.nebula.widgets.nattable.fillhandle.action.FillHandleColumnAction;
import org.eclipse.nebula.widgets.nattable.fillhandle.action.FillHandleCursorAction;
import org.eclipse.nebula.widgets.nattable.fillhandle.action.FillHandleDragMode;
import org.eclipse.nebula.widgets.nattable.fillhandle.command.FillHandlePasteCommandHandler;
import org.eclipse.nebula.widgets.nattable.fillhandle.event.FillHandleEventMatcher;
import org.eclipse.nebula.widgets.nattable.fillhandle.event.FillHandleMarkupListener;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.ui.action.ClearCursorAction;
import org.eclipse.nebula.widgets.nattable.ui.action.NoOpMouseAction;
import org.eclipse.nebula.widgets.nattable.ui.binding.UiBindingRegistry;

public class FillHandleConfiguration
extends AbstractLayerConfiguration<NatTable> {
    protected SelectionLayer selectionLayer;
    protected FillHandleLayerPainter painter;
    protected InternalCellClipboard clipboard;
    private FillHandleBoundsProvider fillHandleBoundsProvider;

    public FillHandleConfiguration(SelectionLayer selectionLayer) {
        this(selectionLayer, null);
    }

    public FillHandleConfiguration(SelectionLayer selectionLayer, FillHandleBoundsProvider boundsProvider) {
        if (selectionLayer == null) {
            throw new IllegalArgumentException("SelectionLayer can not be null");
        }
        this.selectionLayer = selectionLayer;
        this.fillHandleBoundsProvider = boundsProvider;
    }

    @Override
    public void configureTypedLayer(NatTable natTable) {
        this.clipboard = natTable.getInternalCellClipboard();
        this.painter = new FillHandleLayerPainter(this.clipboard);
        this.selectionLayer.setLayerPainter(this.painter);
        this.selectionLayer.addLayerListener(new FillHandleMarkupListener(this.selectionLayer));
        this.selectionLayer.registerCommandHandler(new InternalCopyDataCommandHandler(this.selectionLayer, this.clipboard));
        this.selectionLayer.registerCommandHandler(new FillHandlePasteCommandHandler(this.selectionLayer, this.clipboard));
    }

    @Override
    public void configureUiBindings(UiBindingRegistry uiBindingRegistry) {
        FillHandleEventMatcher matcher = this.fillHandleBoundsProvider != null ? new FillHandleEventMatcher(this.fillHandleBoundsProvider) : new FillHandleEventMatcher((FillHandleBoundsProvider)this.painter);
        uiBindingRegistry.registerFirstMouseMoveBinding(matcher, new FillHandleCursorAction(), new ClearCursorAction());
        uiBindingRegistry.registerFirstMouseDragMode(matcher, new FillHandleDragMode(this.selectionLayer, this.clipboard));
        uiBindingRegistry.registerDoubleClickBinding(matcher, new FillHandleColumnAction(this.selectionLayer, this.clipboard));
        uiBindingRegistry.registerFirstMouseDownBinding(matcher, new NoOpMouseAction());
    }
}

