/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.datachange;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.nebula.widgets.nattable.datachange.AbstractDataChangeHandler;
import org.eclipse.nebula.widgets.nattable.datachange.CellKeyHandler;
import org.eclipse.nebula.widgets.nattable.datachange.DataChangeLayer;
import org.eclipse.nebula.widgets.nattable.datachange.RowDeleteDataChange;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEventHandler;
import org.eclipse.nebula.widgets.nattable.layer.event.IStructuralChangeEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.RowObjectDeleteEvent;

public class RowDeleteDataChangeHandler
extends AbstractDataChangeHandler<RowDeleteDataChange>
implements ILayerEventHandler<RowObjectDeleteEvent> {
    public RowDeleteDataChangeHandler(DataChangeLayer layer, CellKeyHandler<?> keyHandler) {
        super(layer, keyHandler, new ConcurrentHashMap());
    }

    @Override
    public void handleStructuralChange(IStructuralChangeEvent event) {
    }

    @Override
    public boolean isColumnDirty(int columnPosition) {
        return !this.dataChanges.isEmpty();
    }

    @Override
    public boolean isRowDirty(int rowPosition) {
        return false;
    }

    @Override
    public boolean isCellDirty(int columnPosition, int rowPosition) {
        return false;
    }

    @Override
    public boolean isDirty() {
        return !this.dataChanges.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleLayerEvent(RowObjectDeleteEvent event) {
        if (this.handleDataUpdate) {
            Map map = this.dataChanges;
            synchronized (map) {
                TreeMap map2 = new TreeMap(Collections.reverseOrder());
                map2.putAll(event.getDeletedObjects());
                for (Map.Entry deleted : map2.entrySet()) {
                    this.dataChanges.put(deleted.getKey(), new RowDeleteDataChange((Integer)deleted.getKey(), deleted.getValue()));
                    this.layer.addDataChange(new RowDeleteDataChange((Integer)deleted.getKey(), deleted.getValue()));
                }
            }
        }
    }

    @Override
    public Class<RowObjectDeleteEvent> getLayerEventClass() {
        return RowObjectDeleteEvent.class;
    }
}

