/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.markerlistener.providers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.infra.services.markerlistener.Activator;
import org.eclipse.papyrus.infra.services.markerlistener.IPapyrusMarker;
import org.eclipse.swt.widgets.Display;

class MarkerCache {
    private final Map<Resource, Collection<? extends IPapyrusMarker>> cache = new ConcurrentHashMap<Resource, Collection<? extends IPapyrusMarker>>();
    private final CacheLoader loader;

    MarkerCache(CacheLoader loader) {
        this.loader = loader;
    }

    public Collection<? extends IPapyrusMarker> getMarkers(Resource resource) {
        Collection<? extends IPapyrusMarker> result = this.cache.get(resource);
        if (result == null) {
            try {
                result = this.loader.getMarkers(resource);
            }
            catch (CoreException e) {
                Activator.log.error("Could not get markers for resource: " + String.valueOf(resource.getURI()), (Throwable)e);
                result = Collections.emptyList();
            }
            this.cache.put(resource, result);
            this.purgeFromCacheLater(resource);
        }
        return result;
    }

    public Collection<IPapyrusMarker> getMarkers(Resource context, EObject object) {
        List<IPapyrusMarker> result = null;
        for (IPapyrusMarker iPapyrusMarker : this.getMarkers(context)) {
            if (iPapyrusMarker.getEObject() != object) continue;
            if (result == null) {
                result = new ArrayList<IPapyrusMarker>();
            }
            result.add(iPapyrusMarker);
        }
        if (result == null) {
            result = Collections.emptyList();
        }
        return result;
    }

    private void purgeFromCacheLater(final Resource resource) {
        Display display = Display.getDefault();
        if (display != null) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    MarkerCache.this.cache.remove(resource);
                }
            });
        }
    }

    static interface CacheLoader {
        public Collection<? extends IPapyrusMarker> getMarkers(Resource var1) throws CoreException;
    }
}

