/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.uml.ExecutionSpecification;

public class LifelineModelChildrenHelper {
    public static List<View> getModelChildren(View lifeline) {
        if (lifeline == null) {
            return Collections.emptyList();
        }
        ArrayList<View> children = new ArrayList<View>((Collection<View>)lifeline.getVisibleChildren());
        List<View> result = LifelineModelChildrenHelper.sortChildren(children);
        return result;
    }

    private static List<View> sortChildren(List<View> children) {
        ArrayList<View> result = new ArrayList<View>();
        ArrayList<View> original = new ArrayList<View>(children);
        Iterator iterator = original.iterator();
        while (iterator.hasNext()) {
            View view = (View)iterator.next();
            EObject elt = ViewUtil.resolveSemanticElement((View)view);
            if (elt instanceof ExecutionSpecification) continue;
            result.add(view);
            iterator.remove();
        }
        result.addAll(LifelineModelChildrenHelper.doSortExecutionSpecifications(original));
        return result;
    }

    private static List<View> doSortExecutionSpecifications(List<View> executionSpecifications) {
        if (executionSpecifications.isEmpty()) {
            return executionSpecifications;
        }
        ArrayList<View> views = new ArrayList<View>(executionSpecifications);
        ArrayList<View> result = new ArrayList<View>(executionSpecifications.size());
        int minX = -1;
        for (View view : views) {
            Rectangle rect = LifelineModelChildrenHelper.getViewBounds(view);
            if (minX != -1 && rect.x >= minX) continue;
            minX = rect.x;
        }
        ArrayList<View> firstLevelViews = new ArrayList<View>();
        for (View view : views) {
            Rectangle rect = LifelineModelChildrenHelper.getViewBounds(view);
            if (rect.x < minX - 2 || rect.x > minX + 2) continue;
            firstLevelViews.add(view);
        }
        List<View> insertViews = LifelineModelChildrenHelper.doSortVertically(firstLevelViews);
        for (View view : insertViews) {
            LifelineModelChildrenHelper.doInsert(view, result, views, new ArrayList<View>(insertViews));
        }
        ArrayList<View> remains = new ArrayList<View>();
        for (View view : views) {
            if (result.contains(view)) continue;
            remains.add(view);
        }
        insertViews = LifelineModelChildrenHelper.doSortVertically(remains);
        for (View view : remains) {
            LifelineModelChildrenHelper.doInsert(view, result, views, new ArrayList<View>(insertViews));
        }
        return result;
    }

    private static void doInsert(View view, List<View> result, List<View> allViews, List<View> ignoreViews) {
        Rectangle r1 = LifelineModelChildrenHelper.getViewBounds(view);
        r1.width = 16;
        if (!result.contains(view)) {
            result.add(view);
        }
        ignoreViews.add(view);
        List<View> newLevelViews = new ArrayList<View>();
        for (View v : allViews) {
            if (ignoreViews.contains(v)) continue;
            Rectangle r2 = LifelineModelChildrenHelper.getViewBounds(v);
            r2.width = 16;
            if (r2.x <= r1.x || r2.x >= r1.right() || r2.y < r1.y || r2.y > r1.bottom()) continue;
            newLevelViews.add(v);
        }
        newLevelViews = LifelineModelChildrenHelper.doSortVertically(newLevelViews);
        ignoreViews.addAll(newLevelViews);
        for (View v : newLevelViews) {
            LifelineModelChildrenHelper.doInsert(v, result, allViews, ignoreViews);
        }
    }

    private static List<View> doSortVertically(List<View> views) {
        ArrayList<View> insertViews = new ArrayList<View>();
        int i = 0;
        while (i < views.size()) {
            View current = views.get(i);
            Rectangle r1 = LifelineModelChildrenHelper.getViewBounds(current);
            int index = insertViews.size();
            int j = 0;
            while (j < insertViews.size()) {
                Rectangle r2 = LifelineModelChildrenHelper.getViewBounds((View)insertViews.get(j));
                if (r1.y < r2.y) {
                    index = j;
                }
                ++j;
            }
            insertViews.add(index, current);
            ++i;
        }
        return insertViews;
    }

    private static Rectangle getViewBounds(View view) {
        if (view == null) {
            return null;
        }
        Integer x = LifelineModelChildrenHelper.getFeatureValue(view, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X());
        Integer y = LifelineModelChildrenHelper.getFeatureValue(view, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y());
        Integer width = LifelineModelChildrenHelper.getFeatureValue(view, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width());
        Integer height = LifelineModelChildrenHelper.getFeatureValue(view, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height());
        if (x == null && y == null && width == null && height == null) {
            return null;
        }
        return new Rectangle(x == null ? 0 : x, y == null ? 0 : y, width == null ? -1 : width, height == null ? -1 : height);
    }

    private static Integer getFeatureValue(View view, EStructuralFeature feature) {
        if (view == null || feature == null) {
            return null;
        }
        return (Integer)ViewUtil.getPropertyValue((View)view, (EStructuralFeature)feature, (EClass)feature.getEContainingClass());
    }
}

