/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.efacet.core.internal.query;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.emf.facet.efacet.core.IDerivedTypedElementManager;
import org.eclipse.papyrus.emf.facet.efacet.core.IFacetManager;
import org.eclipse.papyrus.emf.facet.efacet.core.exception.DerivedTypedElementException;
import org.eclipse.papyrus.emf.facet.efacet.core.exception.FacetManagerException;
import org.eclipse.papyrus.emf.facet.efacet.core.internal.exception.DerivedTypedElementEvaluationException;
import org.eclipse.papyrus.emf.facet.efacet.core.query.IQueryImplementation;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.DerivedTypedElement;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.ParameterValue;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.extensible.Query;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.query.OperationCallQuery;

public class OperationCallQueryImplementation
implements IQueryImplementation {
    private boolean checkResultType = false;
    private final IDerivedTypedElementManager derivedTEManager;

    public OperationCallQueryImplementation(IDerivedTypedElementManager derivedTEManager) {
        this.derivedTEManager = derivedTEManager;
    }

    @Override
    public Object getValue(Query query, DerivedTypedElement feature, EObject source, List<ParameterValue> parameterValues, IFacetManager facetManager) throws DerivedTypedElementException {
        Object result;
        OperationCallQuery opQuery = (OperationCallQuery)query;
        ArrayList<Object> operationArgs = new ArrayList<Object>();
        for (Query queryArgument : opQuery.getArguments()) {
            operationArgs.add(this.derivedTEManager.evaluate(queryArgument, source, parameterValues, facetManager));
        }
        try {
            result = facetManager.invoke(source, opQuery.getOperation(), null, null, operationArgs.toArray());
        }
        catch (FacetManagerException e) {
            throw new DerivedTypedElementEvaluationException("Operation call evaluation failed", e);
        }
        return result;
    }

    @Override
    public void setValue(Query query, DerivedTypedElement feature, EObject source, List<ParameterValue> parameterValues, Object newValue) throws DerivedTypedElementException {
        throw new DerivedTypedElementEvaluationException("A set operation cannot be performed through an operation call.");
    }

    public void setCheckResultType(boolean checkResultType) {
        this.checkResultType = checkResultType;
    }

    @Override
    public boolean isCheckResultType() {
        return this.checkResultType;
    }
}

