/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.editor.internal.viewpoint;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.infra.architecture.ArchitectureDomainManager;
import org.eclipse.papyrus.infra.architecture.representation.PapyrusRepresentationKind;
import org.eclipse.papyrus.infra.tools.util.ClassLoaderHelper;
import org.eclipse.papyrus.infra.viewpoints.policy.IViewTypeHelper;
import org.eclipse.papyrus.infra.viewpoints.policy.PolicyChecker;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;
import org.eclipse.papyrus.sirius.editor.Activator;
import org.eclipse.papyrus.sirius.editor.internal.viewpoint.SiriusDiagramViewPrototype;
import org.eclipse.papyrus.sirius.editor.representation.ICreateSiriusDiagramEditorCommand;
import org.eclipse.papyrus.sirius.editor.representation.RepresentationPackage;
import org.eclipse.papyrus.sirius.editor.representation.SiriusDiagramPrototype;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.viewpoint.description.DAnnotation;

public class CreateSiriusDiagramViewTypeCommandHelper
implements IViewTypeHelper {
    private Map<PapyrusRepresentationKind, SiriusDiagramViewPrototype> cache;

    public boolean isSupported(EClass type) {
        return EcoreUtil.equals((EObject)type, (EObject)RepresentationPackage.eINSTANCE.getSiriusDiagramPrototype());
    }

    public boolean isSupported(EObject view) {
        return view instanceof DSemanticDiagram;
    }

    public ViewPrototype getPrototypeFor(PapyrusRepresentationKind kind) {
        if (!(kind instanceof SiriusDiagramPrototype)) {
            return null;
        }
        SiriusDiagramPrototype siriusDiagram = (SiriusDiagramPrototype)kind;
        if (this.cache == null) {
            this.cache = new HashMap<PapyrusRepresentationKind, SiriusDiagramViewPrototype>();
        }
        if (this.cache.containsKey(siriusDiagram)) {
            return this.cache.get(siriusDiagram);
        }
        String creationCommandClassName = siriusDiagram.getCreationCommandClass();
        if (creationCommandClassName == null || creationCommandClassName.isEmpty()) {
            return null;
        }
        Class creationCommandClass = ClassLoaderHelper.loadClass((String)creationCommandClassName);
        if (creationCommandClass != null) {
            try {
                Constructor constructor = creationCommandClass.getDeclaredConstructor(new Class[0]);
                Object newInstance = constructor.newInstance(new Object[0]);
                if (newInstance instanceof ICreateSiriusDiagramEditorCommand) {
                    ICreateSiriusDiagramEditorCommand command = (ICreateSiriusDiagramEditorCommand)newInstance;
                    SiriusDiagramViewPrototype proto = new SiriusDiagramViewPrototype(siriusDiagram, command);
                    this.cache.put((PapyrusRepresentationKind)siriusDiagram, proto);
                    return proto;
                }
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | SecurityException e) {
                Activator.log.error("Unexpected Error", (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                Activator.log.error("Unexpected Error", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                Activator.log.error("Unexpected Error", (Throwable)e);
            }
        }
        return null;
    }

    public ViewPrototype getPrototypeOf(EObject view) {
        if (!this.isSupported(view)) {
            return null;
        }
        DSemanticDiagram dsd = (DSemanticDiagram)view;
        DAnnotation annotation = dsd.getDAnnotation("Papyrus-SiriusDiagram");
        String protoID = (String)annotation.getDetails().get((Object)"Papyrus-SiriusDiagram-ImplementationId");
        PolicyChecker checker = PolicyChecker.getFor((EObject)view);
        ArchitectureDomainManager manager = ArchitectureDomainManager.getInstance();
        SiriusDiagramPrototype repKind = (SiriusDiagramPrototype)manager.getRepresentationKindById(protoID);
        if (repKind != null && checker.isInViewpoint((PapyrusRepresentationKind)repKind)) {
            return this.getPrototypeFor((PapyrusRepresentationKind)repKind);
        }
        return ViewPrototype.UNAVAILABLE_VIEW;
    }
}

