/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.decoratormodel.internal.resource.index;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.papyrus.uml.decoratormodel.internal.resource.index.AbstractUMLIndexHandler;
import org.xml.sax.Attributes;

public class ProfileIndexHandler
extends AbstractUMLIndexHandler {
    private final Set<String> referencedModelURIs = Sets.newHashSet();
    private String externalizationName;
    private String dependencyType;
    private String client;
    private String profileApplication;
    private String appliedProfile;
    private Map<String, URI> packageClients = Maps.newHashMap();
    private AbstractUMLIndexHandler.URIPair currentProfileApplication;
    private Multimap<String, AbstractUMLIndexHandler.URIPair> packageProfileApplications = ArrayListMultimap.create();

    public ProfileIndexHandler(URI fileURI) {
        super(fileURI);
    }

    public Set<String> getReferencedModelURIs() {
        return this.referencedModelURIs;
    }

    public String getExternalizationName() {
        return this.externalizationName == null ? "<unnamed>" : this.externalizationName;
    }

    @Override
    protected void initializeUMLElementNames() {
        super.initializeUMLElementNames();
        this.dependencyType = this.umlElement("Dependency");
        this.client = "client";
        this.profileApplication = "profileApplication";
        this.appliedProfile = "appliedProfile";
    }

    @Override
    protected void enterPackage(AbstractUMLIndexHandler.UMLElement package_, Attributes attributes) {
        if (package_.parent == null) {
            this.externalizationName = attributes.getValue("name");
        }
    }

    @Override
    protected boolean doHandleUMLElement(AbstractUMLIndexHandler.UMLElement element, Attributes attributes) {
        boolean result = false;
        if (element.isA(this.dependencyType)) {
            this.await(this.client);
            result = true;
        } else if (element.isRole(this.profileApplication)) {
            this.currentProfileApplication = new AbstractUMLIndexHandler.URIPair();
            this.packageProfileApplications.put((Object)this.currentPackage.id, (Object)this.currentProfileApplication);
            this.await(this.appliedProfile);
            result = true;
        }
        return result;
    }

    @Override
    protected void handleAwaitedElement(AbstractUMLIndexHandler.UMLElement element) {
        if (element.isRole(this.client) && element.isPackage()) {
            this.handleDependencyClient(element);
        } else if (element.isRole(this.appliedProfile)) {
            this.handleAppliedProfile(element);
        }
    }

    protected void handleDependencyClient(AbstractUMLIndexHandler.UMLElement client) {
        URI href = client.getHREF();
        if (href != null) {
            this.referencedModelURIs.add(href.trimFragment().toString());
            this.packageClients.put(this.currentPackage.id, href);
        }
    }

    @Override
    protected void handleAnnotationReferences(AbstractUMLIndexHandler.UMLElement references) {
        URI href = references.getHREF();
        if (href != null) {
            this.currentProfileApplication.second = href;
        }
    }

    protected void handleAppliedProfile(AbstractUMLIndexHandler.UMLElement appliedProfile) {
        URI href = appliedProfile.getHREF();
        if (href != null) {
            this.currentProfileApplication.first = href;
        }
    }

    @Override
    protected void summarize() {
        for (String packageID : this.packageProfileApplications.keySet()) {
            Collection profileApplications;
            URI applyingPackageURI = this.packageClients.get(packageID);
            if (applyingPackageURI == null || (profileApplications = this.packageProfileApplications.get((Object)packageID)).isEmpty()) continue;
            HashMap map = this.getProfileApplicationsByPackage().get(applyingPackageURI.toString());
            if (map == null) {
                map = Maps.newHashMap();
                this.getProfileApplicationsByPackage().put(applyingPackageURI.toString(), map);
            }
            for (AbstractUMLIndexHandler.URIPair profileApplication : profileApplications) {
                if (profileApplication.second == null) continue;
                map.put(profileApplication.first.toString(), profileApplication.second.toString());
            }
        }
    }
}

