/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.profile.service;

import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.ui.dialogs.DiagnosticDialog;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.ui.action.ValidateAction;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.core.resource.IModel;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.services.validation.ValidationTool;
import org.eclipse.papyrus.infra.ui.lifecycleevents.DoSaveEvent;
import org.eclipse.papyrus.infra.ui.lifecycleevents.ISaveEventListener;
import org.eclipse.papyrus.uml.diagram.profile.custom.commands.DefineProfileCommand;
import org.eclipse.papyrus.uml.diagram.profile.custom.messages.Messages;
import org.eclipse.papyrus.uml.diagram.profile.service.GenModelHelper;
import org.eclipse.papyrus.uml.profile.Activator;
import org.eclipse.papyrus.uml.profile.ui.dialogs.ProfileDefinitionDialog;
import org.eclipse.papyrus.uml.tools.model.UmlModel;
import org.eclipse.papyrus.uml.tools.profile.definition.PapyrusDefinitionAnnotation;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.operations.IWorkbenchOperationSupport;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;

public class PreSaveProfileListener
implements ISaveEventListener {
    public void doSave(DoSaveEvent event) {
        if (event.isAutoSave()) {
            return;
        }
        try {
            Profile rootProfile = null;
            ServicesRegistry registry = event.getServiceRegistry();
            ModelSet modelSet = ServiceUtils.getInstance().getModelSet((Object)registry);
            IModel umlModel = modelSet.getModel("org.eclipse.papyrus.infra.core.resource.uml.UmlModel");
            EObject profileEObject = null;
            if (umlModel != null) {
                profileEObject = ((UmlModel)umlModel).lookupRoot();
            }
            if (profileEObject instanceof Profile) {
                rootProfile = (Profile)profileEObject;
            }
            if (rootProfile == null || this.isStaticallyGenerated(rootProfile, (ResourceSet)modelSet)) {
                return;
            }
            String defineMsg = Messages.PreSaveProfileListener_0;
            String defineTitle = Messages.PreSaveProfileListener_8;
            Shell activeShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            boolean result = MessageDialog.openQuestion((Shell)activeShell, (String)defineTitle, (String)defineMsg);
            if (!result) {
                return;
            }
            ProfileDefinitionDialog dialog = new ProfileDefinitionDialog(activeShell, rootProfile);
            dialog.open();
            if (dialog.getReturnCode() == 0) {
                PapyrusDefinitionAnnotation papyrusAnnotation = dialog.getPapyrusDefinitionAnnotation();
                TransactionalEditingDomain domain = ServiceUtils.getInstance().getTransactionalEditingDomain((Object)registry);
                AdapterFactory adapterFactory = domain instanceof AdapterFactoryEditingDomain ? ((AdapterFactoryEditingDomain)domain).getAdapterFactory() : null;
                Diagnostician diagnostician = this.createDiagnostician(adapterFactory, (IProgressMonitor)new NullProgressMonitor());
                BasicDiagnostic diagnostic = diagnostician.createDefaultDiagnostic((EObject)rootProfile);
                diagnostic.getSeverity();
                Map context = diagnostician.createDefaultContext();
                diagnostician.validate((EObject)rootProfile, (DiagnosticChain)diagnostic, context);
                if (this.canDefine((Diagnostic)diagnostic)) {
                    DefineProfileCommand cmd = new DefineProfileCommand(domain, papyrusAnnotation, rootProfile, dialog.saveConstraintInDefinition());
                    try {
                        IOperationHistory history = ((IWorkbenchOperationSupport)event.getMultiDiagramEditor().getSite().getService(IWorkbenchOperationSupport.class)).getOperationHistory();
                        IStatus status = history.execute((IUndoableOperation)cmd, (IProgressMonitor)new NullProgressMonitor(), null);
                        switch (status.getSeverity()) {
                            case 0: {
                                MessageDialog.openInformation((Shell)activeShell, (String)defineTitle, (String)Messages.PreSaveProfileListener_1);
                                break;
                            }
                            case 2: {
                                Activator.log.warn(status.getMessage());
                                MessageDialog.openWarning((Shell)activeShell, (String)defineTitle, (String)status.getMessage());
                                break;
                            }
                            case 4: {
                                this.notifyErrors(activeShell, cmd.getDiagnostic());
                            }
                        }
                    }
                    catch (ExecutionException e) {
                        Activator.log.error((Throwable)e);
                        MessageDialog.openError((Shell)activeShell, (String)Messages.PreSaveProfileListener_2, (String)NLS.bind((String)Messages.PreSaveProfileListener_3, (Object)e.getMessage()));
                    }
                } else {
                    this.handleDiagnostic((Diagnostic)diagnostic, rootProfile);
                    MessageDialog.openError((Shell)activeShell, (String)Messages.PreSaveProfileListener_4, (String)Messages.PreSaveProfileListener_5);
                }
            }
        }
        catch (Exception e) {
            Activator.log.error("Uncaught exception in profile definition.", (Throwable)e);
        }
    }

    protected void notifyErrors(Shell activeShell, Diagnostic diagnostic) {
        Activator.log.error(diagnostic.getMessage(), diagnostic.getException());
        DiagnosticDialog.openProblem((Shell)activeShell, (String)Messages.PreSaveProfileListener_6, (String)Messages.PreSaveProfileListener_7, (Diagnostic)diagnostic);
    }

    protected boolean canDefine(Diagnostic diagnostic) {
        int severity = diagnostic.getSeverity();
        if (severity == 8) {
            return false;
        }
        if (severity == 4) {
            for (Diagnostic childDiagnostic : diagnostic.getChildren()) {
                if (childDiagnostic.getSeverity() != 4 || childDiagnostic.getData().isEmpty() || !(childDiagnostic.getData().get(0) instanceof Element)) continue;
                return false;
            }
        }
        return true;
    }

    protected Diagnostician createDiagnostician(final AdapterFactory adapterFactory, final IProgressMonitor progressMonitor) {
        return new Diagnostician(){

            public String getObjectLabel(EObject eObject) {
                IItemLabelProvider itemLabelProvider;
                if (adapterFactory != null && !eObject.eIsProxy() && (itemLabelProvider = (IItemLabelProvider)adapterFactory.adapt((Notifier)eObject, IItemLabelProvider.class)) != null) {
                    return itemLabelProvider.getText((Object)eObject);
                }
                return super.getObjectLabel(eObject);
            }

            public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
                progressMonitor.worked(1);
                return super.validate(eClass, eObject, diagnostics, context);
            }
        };
    }

    protected void handleDiagnostic(Diagnostic diagnostic, Profile profil) {
        Resource resource = profil.eResource();
        if (resource != null) {
            if (profil != null) {
                ValidationTool vt = new ValidationTool((EObject)profil);
                vt.deleteSubMarkers();
            }
            ValidateAction.EclipseResourcesUtil eclipseResourcesUtil = new ValidateAction.EclipseResourcesUtil();
            for (Diagnostic childDiagnostic : diagnostic.getChildren()) {
                eclipseResourcesUtil.createMarkers(resource, childDiagnostic);
            }
        }
    }

    public void doSaveAs(DoSaveEvent event) {
    }

    boolean isStaticallyGenerated(Profile profile, ResourceSet resourceSet) {
        return GenModelHelper.getInstance().hasGeneratorModel((Package)profile, resourceSet);
    }
}

