/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.wizards.command;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.sasheditor.DiModelUtils;
import org.eclipse.papyrus.infra.core.resource.sasheditor.SashModel;
import org.eclipse.papyrus.infra.core.resource.sasheditor.SashModelUtils;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationUtils;
import org.eclipse.papyrus.uml.diagram.wizards.utils.WizardsHelper;
import org.eclipse.papyrus.uml.tools.model.UmlUtils;

public class InitFromTemplateCommand
extends RecordingCommand {
    private final ModelSet myModelSet;
    private final String myUmlTemplatePath;
    private final String myDiTemplatePath;
    private final String myNotationTemplatePath;
    private final String myPluginId;

    public InitFromTemplateCommand(TransactionalEditingDomain editingDomain, ModelSet modelSet, String pluginId, String umlTemplatePath, String notationTemplatePath, String diTemplatePath) {
        super(editingDomain);
        this.myModelSet = modelSet;
        this.myPluginId = pluginId;
        this.myUmlTemplatePath = umlTemplatePath;
        this.myDiTemplatePath = diTemplatePath;
        this.myNotationTemplatePath = notationTemplatePath;
    }

    protected void doExecute() {
        try {
            this.initializeFromTemplate();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void initializeFromTemplate() throws IOException {
        Resource templateDiResource = null;
        Resource templateNotationResource = null;
        Resource templateUmlResource = null;
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        try {
            templateUmlResource = this.loadTemplateResource(this.myUmlTemplatePath, (ResourceSet)resourceSet);
            EcoreUtil.resolveAll((Resource)templateUmlResource);
            if (this.myDiTemplatePath != null && this.myNotationTemplatePath != null) {
                String diFileName = WizardsHelper.getFileNameWithoutExtension(this.myDiTemplatePath);
                String umlFileName = WizardsHelper.getFileNameWithoutExtension(this.myUmlTemplatePath);
                String notationFileName = WizardsHelper.getFileNameWithoutExtension(this.myNotationTemplatePath);
                if (diFileName.contentEquals(umlFileName) && diFileName.contentEquals(notationFileName)) {
                    if (this.myDiTemplatePath != null) {
                        templateDiResource = this.loadTemplateResource(this.myDiTemplatePath, (ResourceSet)resourceSet);
                        EcoreUtil.resolveAll((Resource)templateDiResource);
                    }
                    if (this.myNotationTemplatePath != null) {
                        templateNotationResource = this.loadTemplateResource(this.myNotationTemplatePath, (ResourceSet)resourceSet);
                        EcoreUtil.resolveAll((Resource)templateNotationResource);
                    }
                }
            }
            EcoreUtil.Copier copier = new EcoreUtil.Copier();
            Collection umlObjects = copier.copyAll((Collection)templateUmlResource.getContents());
            Collection diObjects = templateDiResource == null ? null : copier.copyAll((Collection)templateDiResource.getContents());
            Collection notationObjects = templateNotationResource == null ? null : copier.copyAll((Collection)templateNotationResource.getContents());
            copier.copyReferences();
            Resource myModelUMLResource = UmlUtils.getUmlResource((ModelSet)this.myModelSet);
            myModelUMLResource.getContents().addAll(umlObjects);
            if (diObjects != null) {
                Resource myModelDiResource = DiModelUtils.getDiResource((ModelSet)this.myModelSet);
                myModelDiResource.getContents().addAll(diObjects);
                SashModel myModelSashModel = SashModelUtils.getSashModel((ModelSet)this.myModelSet);
                myModelSashModel.loadModel(this.myModelSet.getURIWithoutExtension());
            }
            if (notationObjects != null) {
                Resource myModelNotationResource = NotationUtils.getNotationResource((ModelSet)this.myModelSet);
                myModelNotationResource.getContents().addAll(notationObjects);
            }
        }
        finally {
            EMFHelper.unload((ResourceSet)resourceSet);
        }
    }

    private Resource loadTemplateResource(String path, ResourceSet resourceSet) {
        String fullUri;
        URI uri;
        Resource resource;
        URL templateURL = Platform.getBundle((String)this.myPluginId).getResource(path);
        if (templateURL != null && (resource = resourceSet.getResource(uri = URI.createPlatformPluginURI((String)(this.myPluginId + (fullUri = templateURL.getPath())), (boolean)true), true)).isLoaded()) {
            return resource;
        }
        return null;
    }
}

