/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.internationalization.modelresource;

import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.internationalization.Activator;
import org.eclipse.papyrus.infra.internationalization.modelresource.AbstractInternationalizationPreferenceModelProvider;
import org.eclipse.papyrus.infra.internationalization.modelresource.IInternationalizationPreferenceModelProvider;

class InternationalizationPreferenceModelProviderManager {
    private static final String E_PROVIDER = "internationalizationPreferenceModelProvider";
    private static final String EXT_PT = "org.eclipse.papyrus.infra.internationalization.internationalizationPreferenceModelProvider";
    private final ModelSet modelSet;
    private final IInternationalizationPreferenceModelProvider defaultInternationalizationPrefModelProvider;
    private final List<ProviderDescriptor> descriptors;

    public InternationalizationPreferenceModelProviderManager(ModelSet modelSet) {
        this.modelSet = modelSet;
        this.defaultInternationalizationPrefModelProvider = this.createDefaultInternationalizationPrefModelProvider();
        this.descriptors = new CopyOnWriteArrayList<ProviderDescriptor>(this.createDescriptors());
    }

    protected void dispose() {
        for (ProviderDescriptor next : this.descriptors) {
            next.dispose();
        }
    }

    protected IInternationalizationPreferenceModelProvider getInternationalizationPreferenceModelProvider(final URI userModelURI) {
        IInternationalizationPreferenceModelProvider result = null;
        ProviderDescriptor descriptor = (ProviderDescriptor)Iterables.find(this.descriptors, (Predicate)new Predicate<Predicate<URI>>(){

            public boolean apply(Predicate<URI> input) {
                return input.apply((Object)userModelURI);
            }
        });
        try {
            result = descriptor.getProvider();
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log(e.getStatus());
            result = this.defaultInternationalizationPrefModelProvider;
            this.descriptors.remove(descriptor);
        }
        return result;
    }

    private List<ProviderDescriptor> createDescriptors() {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)1);
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(EXT_PT);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement next = iConfigurationElementArray[n2];
            if (E_PROVIDER.equals(next.getName())) {
                try {
                    result.add(new ProviderDescriptor(next));
                }
                catch (CoreException e) {
                    Activator.getDefault().getLog().log(e.getStatus());
                }
            }
            ++n2;
        }
        result.add(new ProviderDescriptor(this.defaultInternationalizationPrefModelProvider));
        return result;
    }

    private IInternationalizationPreferenceModelProvider createDefaultInternationalizationPrefModelProvider() {
        return new AbstractInternationalizationPreferenceModelProvider(){

            @Override
            public URI getInternationalizationPreferenceModelURI(URI userModelURI) {
                Assert.isNotNull((Object)userModelURI);
                IPath internationalizationWorkspaceLocation = Activator.getDefault().getStateLocation();
                URI modelURI = userModelURI.trimFileExtension();
                URI internationalizationModelURI = null;
                if (modelURI.isPlatform()) {
                    internationalizationModelURI = URI.createFileURI((String)internationalizationWorkspaceLocation.append(modelURI.toPlatformString(true)).toString());
                    internationalizationModelURI = internationalizationModelURI.appendFileExtension("internationalization");
                } else if (modelURI.isFile()) {
                    String workspaceURI = ResourcesPlugin.getWorkspace().getRoot().getLocationURI().toString();
                    internationalizationModelURI = URI.createFileURI((String)internationalizationWorkspaceLocation.append(modelURI.toString().replaceFirst(workspaceURI, "")).toString());
                    internationalizationModelURI = internationalizationModelURI.appendFileExtension("internationalization");
                } else {
                    internationalizationModelURI = modelURI.appendFileExtension("internationalization");
                }
                return internationalizationModelURI;
            }
        };
    }

    private class ProviderDescriptor
    implements Predicate<URI> {
        private static final String A_SCHEME = "scheme";
        private static final String A_PATTERN = "pattern";
        private static final String A_CLASS = "class";
        private final IConfigurationElement config;
        private final String scheme;
        private final Pattern pattern;
        private IInternationalizationPreferenceModelProvider provider;

        ProviderDescriptor(IInternationalizationPreferenceModelProvider provider) {
            this.provider = provider;
            this.config = null;
            this.scheme = null;
            this.pattern = null;
        }

        ProviderDescriptor(IConfigurationElement config) throws CoreException {
            this.config = config;
            this.scheme = config.getAttribute(A_SCHEME);
            String pattern = config.getAttribute(A_PATTERN);
            if (Strings.isNullOrEmpty((String)this.scheme) && Strings.isNullOrEmpty((String)pattern)) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.papyrus.infra.internationalization", "Internationalization Preference model provider missing both scheme and pattern filter."));
            }
            try {
                this.pattern = pattern == null ? null : Pattern.compile(pattern);
            }
            catch (PatternSyntaxException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.papyrus.infra.internationalization", "Invalid Internationalization Preference model provider URI pattern filter.", (Throwable)e));
            }
        }

        public boolean apply(URI input) {
            return !(this.scheme != null && !this.scheme.equals(input.scheme()) || this.pattern != null && !this.pattern.matcher(input.toString()).find());
        }

        IInternationalizationPreferenceModelProvider getProvider() throws CoreException {
            if (this.provider == null) {
                try {
                    this.provider = (IInternationalizationPreferenceModelProvider)this.config.createExecutableExtension(A_CLASS);
                    this.provider.initialize(InternationalizationPreferenceModelProviderManager.this.modelSet);
                }
                catch (CoreException e) {
                    throw e;
                }
                catch (ClassCastException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.papyrus.infra.internationalization", "Invalid Internationalization Preference model provider implementation.", (Throwable)e));
                }
                catch (Exception e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.papyrus.infra.internationalization", "Failed to initialize Internationalization Preference model provider implementation.", (Throwable)e));
                }
            }
            return this.provider;
        }

        void dispose() {
            if (this.provider != null) {
                try {
                    this.provider.dispose();
                }
                catch (Exception e) {
                    Activator.log.error("Failed to initialize Internationalization Preference model provider implementation.", (Throwable)e);
                }
                this.provider = null;
            }
        }
    }
}

