/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.efacet.ui.internal.composites;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.papyrus.emf.facet.efacet.ui.internal.Messages;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.FilteredList;

public class FilteredElementSelectionComposite
extends Composite {
    private final Text filterText;
    private final FilteredList fFilteredList;

    public FilteredElementSelectionComposite(Composite parent, boolean matchAnywhere, boolean multiSelection) {
        super(parent, 2048);
        this.setLayout((Layout)new GridLayout());
        this.filterText = FilteredElementSelectionComposite.createFilterText(this);
        this.fFilteredList = FilteredElementSelectionComposite.createFilteredList(this, multiSelection);
        final String matchPrefix = matchAnywhere ? "*" : "";
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FilteredElementSelectionComposite.this.getfFilteredList().setFilter(matchPrefix + FilteredElementSelectionComposite.this.getFilterText().getText());
            }
        });
        this.filterText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    FilteredElementSelectionComposite.this.getfFilteredList().setFocus();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
    }

    public void setElements(Object[] elements) {
        this.fFilteredList.setElements(elements);
    }

    protected static FilteredList createFilteredList(Composite parent, boolean multiSelection) {
        int multi = multiSelection ? 2 : 4;
        FilteredList filteredList = new FilteredList(parent, 0xB00 | multi, (ILabelProvider)new LabelProvider(), true, false, true);
        GridData data = new GridData();
        data.grabExcessVerticalSpace = true;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        filteredList.setLayoutData((Object)data);
        filteredList.setFilter("");
        return filteredList;
    }

    protected static Text createFilterText(Composite parent) {
        Text text = new Text(parent, 2048);
        text.setMessage(Messages.FilteredElementSelectionControl_type_filter_text);
        GridData data = new GridData();
        data.grabExcessVerticalSpace = false;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        text.setLayoutData((Object)data);
        return text;
    }

    public Object getFirstSelectedElement() {
        Object[] selection = this.fFilteredList.getSelection();
        if (selection.length > 0) {
            return selection[0];
        }
        return null;
    }

    public Object[] getSelectedElements() {
        Object[] selection = this.fFilteredList.getSelection();
        if (selection.length == 0) {
            return null;
        }
        return selection;
    }

    public FilteredList getFilteredList() {
        return this.fFilteredList;
    }

    public Text getFilterText() {
        return this.filterText;
    }

    protected FilteredList getfFilteredList() {
        return this.fFilteredList;
    }
}

