/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.decoratormodel.internal.properties.constraints;

import com.google.common.collect.Iterables;
import com.google.common.collect.SetMultimap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.Future;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.infra.constraints.constraints.AbstractConstraint;
import org.eclipse.papyrus.infra.constraints.constraints.Constraint;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.uml.decoratormodel.helper.DecoratorModelUtils;
import org.eclipse.papyrus.uml.decoratormodel.internal.properties.constraints.ProfileApplicationsConstraintException;
import org.eclipse.papyrus.uml.decoratormodel.internal.resource.DecoratorModelIndex;
import org.eclipse.papyrus.uml.decoratormodel.properties.Activator;
import org.eclipse.uml2.uml.Package;

public class HasExternalizedProfileApplicationsConstraint
extends AbstractConstraint {
    protected boolean match(Object selection) {
        boolean result = false;
        EObject object = EMFHelper.getEObject((Object)selection);
        if (object instanceof Package) {
            Package package_ = (Package)object;
            try {
                boolean bl = result = !Iterables.isEmpty((Iterable)DecoratorModelUtils.getDecoratorModelProfileApplications((Package)package_));
                if (!result) {
                    ListenableFuture appliedProfiles = DecoratorModelIndex.getInstance().getAllAppliedProfilesAsync(EcoreUtil.getURI((EObject)package_));
                    result = !appliedProfiles.isDone() || !((SetMultimap)Futures.getChecked((Future)appliedProfiles, ProfileApplicationsConstraintException.class)).isEmpty();
                }
            }
            catch (ProfileApplicationsConstraintException e) {
                Activator.log.error("ProfileApplicationsConstraintException on " + String.valueOf(package_), (Throwable)((Object)e));
            }
        }
        return result;
    }

    protected boolean equivalent(Constraint constraint) {
        if (this == constraint) {
            return true;
        }
        return constraint instanceof HasExternalizedProfileApplicationsConstraint;
    }

    public String toString() {
        return "HasExternalizedProfileApplicationsConstraint";
    }
}

