/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.m2m.qvto.common.transformation;

import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticException;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.ecore.xmi.impl.URIHandlerImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.gmf.runtime.emf.core.resources.GMFResource;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QVTEvaluationOptions;
import org.eclipse.m2m.qvt.oml.BasicModelExtent;
import org.eclipse.m2m.qvt.oml.ExecutionContext;
import org.eclipse.m2m.qvt.oml.ExecutionContextImpl;
import org.eclipse.m2m.qvt.oml.ExecutionDiagnostic;
import org.eclipse.m2m.qvt.oml.ModelExtent;
import org.eclipse.m2m.qvt.oml.TransformationExecutor;
import org.eclipse.m2m.qvt.oml.util.ISessionData;
import org.eclipse.m2m.qvt.oml.util.Log;
import org.eclipse.m2m.qvt.oml.util.Trace;
import org.eclipse.m2m.qvt.oml.util.WriterLog;
import org.eclipse.papyrus.infra.emf.resource.ShardResourceHelper;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.uml.m2m.qvto.common.Activator;
import org.eclipse.papyrus.uml.m2m.qvto.common.MigrationParameters.MigrationParametersFactory;
import org.eclipse.papyrus.uml.m2m.qvto.common.MigrationParameters.ThreadConfig;
import org.eclipse.papyrus.uml.m2m.qvto.common.concurrent.ExecutorsPool;
import org.eclipse.papyrus.uml.m2m.qvto.common.internal.extension.TransformationExtension;
import org.eclipse.papyrus.uml.m2m.qvto.common.transformation.IDependencyAnalysisHelper;
import org.eclipse.papyrus.uml.m2m.qvto.common.transformation.IImportTransformation;
import org.eclipse.papyrus.uml.m2m.qvto.common.transformation.MigrationResourceSet;
import org.eclipse.papyrus.uml.m2m.qvto.common.transformation.MigrationResourceSetImpl;
import org.eclipse.papyrus.uml.m2m.qvto.common.utils.TraceHelper;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.uml2.common.util.CacheAdapter;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.util.UMLUtil;

public abstract class AbstractImportTransformation
implements IImportTransformation {
    protected static boolean DEBUG = true;
    protected final URI sourceURI;
    protected URI targetURI;
    protected ModelExtent outUML;
    protected ModelExtent outNotation;
    protected ModelExtent outSashModel;
    protected ModelExtent inParameters;
    protected ModelExtent inPapyrusProfiles;
    protected ModelExtent sysML11Profile;
    protected MigrationResourceSet resourceSet;
    protected Job job;
    protected Resource umlResource;
    protected ThreadConfig parameters;
    protected boolean complete = false;
    protected long executionTime = 0L;
    protected long loadingTime = 0L;
    protected long danglingRefTime = 0L;
    protected long importExtensionsTime = 0L;
    protected final Map<URI, URI> uriMappings = new HashMap<URI, URI>();
    protected final Map<URI, URI> profileURIMappings = new HashMap<URI, URI>();
    protected List<Diagram> diagramsToDelete = new LinkedList<Diagram>();
    protected static final ExecutorsPool executorsPool = new ExecutorsPool(2);
    protected static final Set<EPackage> sourceEPackages = new HashSet<EPackage>();
    protected final IDependencyAnalysisHelper analysisHelper;
    protected final List<TransformationExtension> extensions;
    private Trace trace = Trace.createEmptyTrace();
    protected ExecutionContext context;

    public AbstractImportTransformation(URI sourceURI) {
        this(sourceURI, MigrationParametersFactory.eINSTANCE.createThreadConfig(), null);
    }

    public AbstractImportTransformation(URI sourceURI, ThreadConfig config, IDependencyAnalysisHelper analysisHelper) {
        Assert.isNotNull((Object)sourceURI);
        this.sourceURI = sourceURI;
        this.parameters = config;
        this.analysisHelper = analysisHelper;
        this.extensions = AbstractImportTransformation.getAllExtensions();
    }

    protected static List<TransformationExtension> getAllExtensions() {
        return Collections.emptyList();
    }

    @Override
    public void run(final boolean isUserJob) {
        this.job = new Job("Import " + this.getModelName()){

            protected IStatus run(IProgressMonitor monitor) {
                long begin = System.nanoTime();
                IStatus result = AbstractImportTransformation.this.run(monitor);
                long end = System.nanoTime();
                AbstractImportTransformation.this.executionTime = end - begin;
                return result;
            }
        };
        this.job.setUser(isUserJob);
        this.job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                AbstractImportTransformation.this.complete = true;
                if (isUserJob) {
                    if (event.getResult().getSeverity() == 0) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)(this).AbstractImportTransformation.this.job.getName(), (String)String.format("Model %s has been successfully imported", AbstractImportTransformation.this.getModelName()));
                            }
                        });
                    } else if (event.getResult().getSeverity() == 8) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)(this).AbstractImportTransformation.this.job.getName(), (String)String.format("Operation canceled: %s", AbstractImportTransformation.this.getModelName()));
                            }
                        });
                    } else {
                        StatusManager.getManager().handle(event.getResult(), 4);
                    }
                }
            }
        });
        this.job.schedule();
    }

    public void waitForCompletion() {
        try {
            this.job.join();
        }
        catch (InterruptedException ex) {
            Activator.log.error((Throwable)ex);
        }
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public IStatus getStatus() {
        if (this.job == null) {
            return new Status(8, "org.eclipse.papyrus.uml.m2m.qvto.common", "Operation canceled");
        }
        return this.job.getResult();
    }

    @Override
    public long getExecutionTime() {
        return this.executionTime;
    }

    @Override
    public long getLoadingTime() {
        return this.loadingTime;
    }

    @Override
    public long getHandleDanglingRefTime() {
        return this.danglingRefTime;
    }

    @Override
    public long getImportExtensionsTime() {
        return this.importExtensionsTime;
    }

    public URI getTargetURI() {
        return this.targetURI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initResourceSet(IProgressMonitor monitor) {
        this.resourceSet = new MigrationResourceSetImpl();
        Class<UMLUtil> clazz = UMLUtil.class;
        synchronized (UMLUtil.class) {
            UMLUtil.init((ResourceSet)this.resourceSet);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.resourceSet.getLoadOptions().put("DEFER_ATTACHMENT", true);
            this.resourceSet.getLoadOptions().put("DEFER_IDREF_RESOLUTION", true);
            this.resourceSet.getLoadOptions().put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
            this.resourceSet.getLoadOptions().put("USE_PACKAGE_NS_URI_AS_LOCATION", Boolean.FALSE);
            monitor.subTask("Loading source model " + this.getModelName());
            try {
                this.resourceSet.getResource(this.sourceURI, true);
                this.loadInPapyrusProfiles();
            }
            catch (Exception ex) {
                Activator.log.error("An error occurred while loading " + this.getModelName(), (Throwable)ex);
            }
            return;
        }
    }

    protected abstract int countSupportedElements();

    protected IStatus loadTransformations(IProgressMonitor monitor) {
        for (URI transformationURI : this.getAllTransformationURIs()) {
            executorsPool.preLoad(transformationURI);
            monitor.worked(1);
        }
        return Status.OK_STATUS;
    }

    protected static IStatus createStatusFromDiagnostic(Diagnostic diagnostic) {
        return new Status(diagnostic.getSeverity(), diagnostic.getSource(), diagnostic.getMessage(), diagnostic.getException());
    }

    protected abstract IStatus run(IProgressMonitor var1);

    protected void prepareExtensions() {
        for (TransformationExtension extension : this.extensions) {
            extension.setResourceSet(this.resourceSet);
            extension.setExecutorsPool(executorsPool);
            extension.setTransformation(this);
        }
    }

    protected IStatus importExtensions(ExecutionContext context, IProgressMonitor monitor, ExtensionFunction function) {
        ArrayList<IStatus> allResults = new ArrayList<IStatus>(this.extensions.size());
        for (TransformationExtension extension : this.extensions) {
            IStatus result = function.apply(extension, context, monitor);
            allResults.add(result);
        }
        if (allResults.isEmpty()) {
            return Status.OK_STATUS;
        }
        if (allResults.size() == 1) {
            return (IStatus)allResults.get(0);
        }
        return AbstractImportTransformation.aggregateStatus(allResults);
    }

    public static MultiStatus aggregateStatus(List<IStatus> statuses) {
        return new MultiStatus("org.eclipse.papyrus.uml.m2m.qvto.common", 0, statuses.toArray(new IStatus[statuses.size()]), "", null);
    }

    protected void cleanMetadataAnnotations(Resource resource) {
        Iterator rootElementsIterator = resource.getContents().iterator();
        while (rootElementsIterator.hasNext()) {
            EAnnotation annotation;
            EObject root = (EObject)rootElementsIterator.next();
            if (!(root instanceof EAnnotation) || !"http:///org/eclipse/emf/ecore/util/ExtendedMetaData".equals((annotation = (EAnnotation)root).getSource())) continue;
            rootElementsIterator.remove();
        }
    }

    protected void handleDanglingURIs(Collection<Resource> resourcesToSave) {
        if (this.analysisHelper != null) {
            this.resourceSet.freeze();
            try {
                this.analysisHelper.computeURIMappings(resourcesToSave);
            }
            finally {
                this.resourceSet.unfreeze();
            }
        }
    }

    protected void unloadResourceSet(ResourceSet resourceSet) {
        EMFHelper.unload((ResourceSet)resourceSet);
    }

    protected TransformationExecutor getTransformation(URI transformationURI, IProgressMonitor monitor) throws DiagnosticException {
        return executorsPool.getExecutor(transformationURI);
    }

    protected ModelExtent getInProfileDefinitions() {
        return null;
    }

    protected ModelExtent getInPapyrusProfiles() {
        if (this.inPapyrusProfiles == null) {
            this.loadInPapyrusProfiles();
        }
        return this.inPapyrusProfiles;
    }

    protected abstract Diagnostic loadInPapyrusProfiles();

    protected void checkResource(Resource resource) {
        Assert.isNotNull((Object)resource);
        Assert.isTrue((!resource.getContents().isEmpty() ? 1 : 0) != 0, (String)("The resource " + String.valueOf(resource.getURI()) + " is empty"));
        for (EObject rootElement : resource.getContents()) {
            Assert.isTrue((!rootElement.eIsProxy() ? 1 : 0) != 0);
        }
    }

    protected abstract Resource createUMLResource(ResourceSet var1, URI var2, URI var3);

    protected ModelExtent getInConfig() {
        if (this.inParameters == null) {
            this.inParameters = new BasicModelExtent(Collections.singletonList(this.parameters));
        }
        return this.inParameters;
    }

    protected Collection<Resource> handleFragments(Resource umlResource, Resource notationResource, Resource sashResource) {
        HashSet<Resource> result = new HashSet<Resource>();
        result.add(umlResource);
        result.add(notationResource);
        result.add(sashResource);
        ResourceSet resourceSet = umlResource.getResourceSet();
        TreeIterator elementIterator = umlResource.getAllContents();
        HashSet<Resource> fragmentResources = new HashSet<Resource>();
        ArrayList rsaAnnotations = new ArrayList();
        while (elementIterator.hasNext()) {
            EObject element = (EObject)elementIterator.next();
            Resource possibleFragment = element.eResource();
            if (possibleFragment == umlResource || !possibleFragment.getContents().contains((Object)element)) continue;
            fragmentResources.add(possibleFragment);
        }
        rsaAnnotations.forEach(EcoreUtil::remove);
        LinkedList<Resource> fragmentUMLResources = new LinkedList<Resource>();
        for (Resource fragmentResource : fragmentResources) {
            XMIResourceImpl fragmentDiResource22;
            Throwable fragmentNotationResource;
            URI papyrusFragmentURI = this.convertToPapyrus(fragmentResource.getURI(), "uml");
            this.uriMappings.put(fragmentResource.getURI(), papyrusFragmentURI);
            Resource newResource = resourceSet.getResource(papyrusFragmentURI, false);
            if (newResource == null) {
                newResource = this.createUMLResource(resourceSet, fragmentResource.getURI(), papyrusFragmentURI);
                fragmentUMLResources.add(newResource);
                fragmentNotationResource = new GMFResource(this.convertToPapyrus(papyrusFragmentURI, "notation"));
                fragmentDiResource22 = new XMIResourceImpl(this.convertToPapyrus(papyrusFragmentURI, "di"));
                result.add((Resource)fragmentNotationResource);
                result.add((Resource)fragmentDiResource22);
                resourceSet.getResources().add((Object)fragmentNotationResource);
                resourceSet.getResources().add((Object)fragmentDiResource22);
            }
            newResource.getContents().addAll((Collection)fragmentResource.getContents());
            fragmentNotationResource = null;
            fragmentDiResource22 = null;
            try (ShardResourceHelper shard = new ShardResourceHelper(newResource);){
                shard.setShard(true);
            }
            catch (Throwable fragmentDiResource22) {
                if (fragmentNotationResource == null) {
                    fragmentNotationResource = fragmentDiResource22;
                } else if (fragmentNotationResource != fragmentDiResource22) {
                    fragmentNotationResource.addSuppressed(fragmentDiResource22);
                }
                throw fragmentNotationResource;
            }
            result.add(newResource);
        }
        this.deleteSourceStereotypes(fragmentResources);
        LinkedList importedElements = new LinkedList(notationResource.getContents());
        for (EObject notationElement : importedElements) {
            EObject semanticElement;
            if (!(notationElement instanceof Diagram) || (semanticElement = ((Diagram)notationElement).getElement()).eResource() == umlResource || semanticElement.eResource() == null) continue;
            URI notationFragmentURI = this.convertToPapyrus(semanticElement.eResource().getURI(), "notation");
            Resource newNotationResource = resourceSet.getResource(notationFragmentURI, false);
            if (newNotationResource == null) {
                newNotationResource = new GMFResource(notationFragmentURI);
                resourceSet.getResources().add((Object)newNotationResource);
            }
            newNotationResource.getContents().add((Object)notationElement);
            result.add(newNotationResource);
        }
        this.handleFragmentStereotypes(umlResource, fragmentUMLResources);
        for (Resource resource : result) {
            if (!(resource instanceof XMIResource)) continue;
            this.configureResource((XMIResource)resource);
        }
        return result;
    }

    protected void handleFragmentStereotypes(Resource mainUMLResource, List<Resource> umlResources) {
        Iterator rootElementIterator = mainUMLResource.getContents().iterator();
        while (rootElementIterator.hasNext()) {
            Resource targetStereotypeResource;
            EObject rootElement = (EObject)rootElementIterator.next();
            if (rootElement instanceof Element || (targetStereotypeResource = this.getTargetStereotypeResource(rootElement, umlResources)) == null || targetStereotypeResource == mainUMLResource) continue;
            rootElementIterator.remove();
            targetStereotypeResource.getContents().add((Object)rootElement);
        }
    }

    protected Resource getTargetStereotypeResource(EObject rootElement, List<Resource> umlResources) {
        for (EReference eReference : rootElement.eClass().getEAllReferences()) {
            Object value;
            if (!eReference.getName().startsWith("base_") || !((value = rootElement.eGet((EStructuralFeature)eReference)) instanceof Element)) continue;
            return ((Element)value).eResource();
        }
        return null;
    }

    protected void deleteSourceStereotypes(Collection<Resource> fragmentResources) {
        HashSet<Resource> allResources = new HashSet<Resource>(fragmentResources);
        allResources.add(this.umlResource);
        for (Resource resource : allResources) {
            LinkedList resourceContents = new LinkedList(resource.getContents());
            for (EObject rootElement : resourceContents) {
                if (!sourceEPackages.contains(rootElement.eClass().getEPackage())) continue;
                this.delete(rootElement);
            }
        }
    }

    protected abstract URI convertToPapyrus(URI var1, String var2);

    public IStatus runTransformation(URI transformationURI, List<ModelExtent> extents, IProgressMonitor monitor) {
        return this.runTransformation(transformationURI, this.context, monitor, extents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus runTransformation(URI transformationURI, ExecutionContext context, IProgressMonitor monitor, List<ModelExtent> extents) {
        ExecutionDiagnostic result;
        TransformationExecutor executor;
        if (monitor.isCanceled()) {
            return new Status(8, "org.eclipse.papyrus.uml.m2m.qvto.common", "Operation canceled");
        }
        try {
            executor = this.getTransformation(transformationURI, monitor);
        }
        catch (DiagnosticException ex) {
            Diagnostic diagnostic = ex.getDiagnostic();
            Activator.log.warn(String.format("Cannot load the transformation : %s. Diagnostic: %s", transformationURI, diagnostic.getMessage()));
            return AbstractImportTransformation.createStatusFromDiagnostic(diagnostic);
        }
        TransformationExecutor transformationExecutor = executor;
        synchronized (transformationExecutor) {
            try {
                Trace newTraces = Trace.createEmptyTrace();
                ISessionData.SimpleEntry traceKey = QVTEvaluationOptions.INCREMENTAL_UPDATE_TRACE;
                context.getSessionData().setValue((ISessionData.Entry)traceKey, (Object)newTraces);
                result = executor.execute(context, extents.toArray(new ModelExtent[0]));
                ArrayList history = new ArrayList(this.trace.getTraceContent());
                history.addAll(newTraces.getTraceContent());
                this.trace.setTraceContent(history);
            }
            finally {
                executor.cleanup();
                executorsPool.releaseExecutor(executor);
            }
        }
        return AbstractImportTransformation.createStatusFromDiagnostic((Diagnostic)result);
    }

    protected ExecutionContext createExecutionContext(IProgressMonitor monitor, final MultiStatus generationStatus) {
        ExecutionContextImpl context = new ExecutionContextImpl();
        context.setConfigProperty("keepModeling", (Object)true);
        context.setConfigProperty("monitor", (Object)monitor);
        context.setLog((Log)new WriterLog(new OutputStreamWriter(System.out)){

            public void log(String message) {
                super.log(message);
            }

            public void log(String message, Object param) {
                super.log(message, param);
            }

            public void log(int level, String message) {
                super.log(level, message);
                if (level >= 1) {
                    generationStatus.merge((IStatus)new Status(level, "org.eclipse.papyrus.uml.m2m.qvto.common", message));
                }
            }

            public void log(int level, String message, Object param) {
                super.log(level, message, param);
                if (level >= 1) {
                    generationStatus.merge((IStatus)new Status(level, "org.eclipse.papyrus.uml.m2m.qvto.common", message + ", data:" + String.valueOf(param)));
                }
            }
        });
        this.initTransformationProperties(context);
        context.getSessionData().setValue(TraceHelper.TRACE_HISTORY, (Object)this.trace);
        return context;
    }

    protected abstract void initTransformationProperties(ExecutionContextImpl var1);

    protected void configureResource(XMIResource resource) {
        HashMap<String, Object> saveOptions = new HashMap<String, Object>();
        saveOptions.put("DECLARE_XML", Boolean.TRUE);
        saveOptions.put("PROCESS_DANGLING_HREF", "DISCARD");
        saveOptions.put("SCHEMA_LOCATION", Boolean.TRUE);
        saveOptions.put("USE_XMI_TYPE", Boolean.TRUE);
        saveOptions.put("SAVE_TYPE_INFORMATION", Boolean.TRUE);
        saveOptions.put("SKIP_ESCAPE_URI", Boolean.FALSE);
        saveOptions.put("ENCODING", "UTF-8");
        saveOptions.put("URI_HANDLER", new URIHandlerImpl.PlatformSchemeAware());
        resource.setEncoding("UTF-8");
        resource.getDefaultSaveOptions().putAll(saveOptions);
    }

    protected abstract List<ModelExtent> getModelExtents();

    public abstract ModelExtent getInOutUMLModel();

    public ModelExtent getInoutNotationModel() {
        if (this.outNotation == null) {
            this.outNotation = new BasicModelExtent();
        }
        return this.outNotation;
    }

    protected ModelExtent getOutSashModel() {
        if (this.outSashModel == null) {
            this.outSashModel = new BasicModelExtent();
        }
        return this.outSashModel;
    }

    protected abstract Collection<URI> getDiagramTransformationURIs();

    protected abstract URI getSemanticTransformationURI();

    protected abstract Collection<URI> getProfilesTransformationURI();

    protected Collection<URI> getAdditionalTransformationURIs() {
        return Collections.emptyList();
    }

    protected abstract Collection<URI> getAllTransformationURIs();

    protected URI getTransformationURI(String transformationName, String pluginID) {
        return URI.createPlatformPluginURI((String)String.format("%s/transform/%s.qvto", pluginID, transformationName), (boolean)true);
    }

    @Override
    public String getModelName() {
        return URI.decode((String)this.sourceURI.lastSegment());
    }

    @Override
    public void cancel() {
        this.job.cancel();
    }

    public void delete(EObject elementToDelete) {
        EObject parent;
        CacheAdapter adapter = CacheAdapter.getCacheAdapter((Notifier)elementToDelete);
        if (adapter == null) {
            adapter = CacheAdapter.getInstance();
        }
        adapter.unsetTarget((Notifier)elementToDelete);
        if (elementToDelete.eResource() != null) {
            elementToDelete.eResource().getContents().remove((Object)elementToDelete);
        }
        if ((parent = elementToDelete.eContainer()) == null) {
            return;
        }
        EReference containmentFeature = elementToDelete.eContainmentFeature();
        if (containmentFeature.getUpperBound() == 1) {
            parent.eUnset((EStructuralFeature)containmentFeature);
        } else {
            List values = (List)parent.eGet((EStructuralFeature)containmentFeature);
            values.remove(elementToDelete);
        }
    }

    protected Trace getTrace() {
        return this.trace;
    }

    @FunctionalInterface
    protected static interface ExtensionFunction {
        public IStatus apply(TransformationExtension var1, ExecutionContext var2, IProgressMonitor var3);

        public static IStatus executeBefore(TransformationExtension extension, ExecutionContext context, IProgressMonitor monitor) {
            return extension.executeBefore(context, monitor);
        }

        public static IStatus executeAfter(TransformationExtension extension, ExecutionContext context, IProgressMonitor monitor) {
            return extension.executeAfter(context, monitor);
        }
    }
}

