/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.m2m.qvto.common.concurrent;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class ResourceAccessHelper {
    public static ResourceAccessHelper INSTANCE = new ResourceAccessHelper();
    private final Map<URI, ReadWriteLock> locks = new HashMap<URI, ReadWriteLock>();

    private ResourceAccessHelper() {
    }

    private Lock getSaveLock(Resource resource) {
        ReadWriteLock lock = this.getLock(resource);
        return lock.writeLock();
    }

    private Lock getLoadLoack(Resource resource) {
        ReadWriteLock lock = this.getLock(resource);
        return lock.readLock();
    }

    public void saveResource(Resource resource, Map<?, ?> options) throws IOException {
        Lock lock = this.getSaveLock(resource);
        lock.lock();
        try {
            resource.save(options);
        }
        finally {
            lock.unlock();
        }
    }

    public void loadResource(Resource resource, Map<?, ?> options) throws IOException {
        Lock lock = this.getLoadLoack(resource);
        lock.lock();
        try {
            resource.load(options);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReadWriteLock getLock(Resource resource) {
        URI uri = resource.getURI();
        if (uri == null) {
            return null;
        }
        ResourceAccessHelper resourceAccessHelper = this;
        synchronized (resourceAccessHelper) {
            if (!this.locks.containsKey(uri)) {
                this.locks.put(uri, new ReentrantReadWriteLock());
            }
            return this.locks.get(uri);
        }
    }
}

