/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.decoration.util;

import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.papyrus.infra.services.decoration.util.IPapyrusDecoration;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class DecorationImageUtils {
    public static final Point SIZE_16_16 = new Point(16, 16);
    public static final int NB_DECORATIONS = 5;

    private DecorationImageUtils() {
    }

    public static final Image getDecoratedImage(Image decoratorTarget, List<IPapyrusDecoration> decorations, Point size) {
        if (decoratorTarget == null) {
            return null;
        }
        if (decorations == null) {
            return decoratorTarget;
        }
        Image decoratedImage = null;
        String decoratedImageId = DecorationImageUtils.calcId(decoratorTarget, decorations);
        decoratedImage = Activator.getDefault().getImageRegistry().get(decoratedImageId);
        if (decoratedImage == null) {
            ImageDescriptor[] decorationImages = new ImageDescriptor[5];
            IPapyrusDecoration[] decorationByPosition = new IPapyrusDecoration[5];
            for (IPapyrusDecoration decoration : decorations) {
                IPapyrusDecoration existingDecoration = decorationByPosition[decoration.getPositionForJFace()];
                if (existingDecoration != null && existingDecoration.getPriority() >= decoration.getPriority()) continue;
                decorationImages[decoration.getPositionForJFace()] = decoration.getDecorationImageForME();
                decorationByPosition[decoration.getPositionForJFace()] = decoration;
            }
            DecorationOverlayIcon decoratedImageDesc = new DecorationOverlayIcon(decoratorTarget, decorationImages, size);
            Activator.getDefault().getImageRegistry().put(decoratedImageId, (ImageDescriptor)decoratedImageDesc);
            return Activator.getDefault().getImageRegistry().get(decoratedImageId);
        }
        return decoratedImage;
    }

    public static final String calcId(Image decoratorTarget, List<IPapyrusDecoration> decorations) {
        long hash = decoratorTarget.hashCode();
        StringBuilder decoratedImageId = new StringBuilder("Image {");
        decoratedImageId.append(hash);
        decoratedImageId.append("}");
        for (IPapyrusDecoration decoration : decorations) {
            decoratedImageId.append(decoration.getDecorationImageForME().toString());
            decoratedImageId.append((Object)decoration.getPosition());
        }
        return decoratedImageId.toString();
    }
}

