/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.nattable.celleditor.config;

import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.edit.editor.ICellEditor;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.TextPainter;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.papyrus.infra.nattable.celleditor.MultiLineTextCellEditorEx;
import org.eclipse.papyrus.infra.nattable.celleditor.config.ICellAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.infra.nattable.utils.NattableConfigAttributes;
import org.eclipse.papyrus.infra.nattable.utils.StyleUtils;

public class SingleStringCellEditorConfiguration
implements ICellAxisConfiguration {
    private static final String ID = "org.eclipse.papyrus.infra.emf.nattable.celleditor.configuration.SingleStringCellEditorConfiguration.MultiLineText";

    public String getConfigurationId() {
        return ID;
    }

    public String getConfigurationDescription() {
        return "This configuration provides a multi-line text editor for a single String";
    }

    public boolean handles(Table table, Object axisElement) {
        EClassifier etype;
        EStructuralFeature feature;
        Object object = AxisUtils.getRepresentedElement((Object)axisElement);
        if (object instanceof EStructuralFeature && !(feature = (EStructuralFeature)object).isMany() && (etype = feature.getEType()) instanceof EDataType) {
            EDataType datatype = (EDataType)etype;
            return "String".equals(datatype.getName()) || "EString".equals(datatype.getName());
        }
        return false;
    }

    public void configureCellEditor(IConfigRegistry configRegistry, Object axis, String configLabel) {
        Object axisElement = AxisUtils.getRepresentedElement((Object)axis);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)this.getCellPainter(configRegistry, axisElement, configLabel), DisplayMode.NORMAL, configLabel);
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)this.getCellEditor(configRegistry, axisElement, configLabel), DisplayMode.EDIT, configLabel);
    }

    protected ICellPainter getCellPainter(IConfigRegistry configRegistry, Object axis, String configLabel) {
        INattableModelManager nattableManager = (INattableModelManager)configRegistry.getConfigAttribute(NattableConfigAttributes.NATTABLE_MODEL_MANAGER_CONFIG_ATTRIBUTE, DisplayMode.NORMAL, new String[]{"nattable_model_manager_id"});
        Table table = nattableManager.getTable();
        boolean wrapTextFlag = StyleUtils.getBooleanNamedStyleValue((Table)table, (String)"wrapText");
        boolean autoResizeCellHeightFlag = StyleUtils.getBooleanNamedStyleValue((Table)table, (String)"autoResizeCellHeight");
        TextPainter textPainter = new TextPainter(wrapTextFlag, true, 2, false, autoResizeCellHeightFlag);
        return textPainter;
    }

    protected ICellEditor getCellEditor(IConfigRegistry configRegistry, Object axis, String configLabel) {
        return new MultiLineTextCellEditorEx(true);
    }
}

