/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.types.constraints.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.infra.emf.types.constraints.AnyReference;
import org.eclipse.papyrus.infra.emf.types.constraints.CompositeConstraint;
import org.eclipse.papyrus.infra.emf.types.constraints.ConstraintAdviceConfiguration;
import org.eclipse.papyrus.infra.emf.types.constraints.ConstraintAdviceFactory;
import org.eclipse.papyrus.infra.emf.types.constraints.ConstraintAdvicePackage;
import org.eclipse.papyrus.infra.emf.types.constraints.ElementTypeFilter;
import org.eclipse.papyrus.infra.emf.types.constraints.ElementTypeRelationshipKind;
import org.eclipse.papyrus.infra.emf.types.constraints.EndKind;
import org.eclipse.papyrus.infra.emf.types.constraints.EndPermission;
import org.eclipse.papyrus.infra.emf.types.constraints.Reference;
import org.eclipse.papyrus.infra.emf.types.constraints.ReferenceConstraint;
import org.eclipse.papyrus.infra.emf.types.constraints.ReferenceKind;
import org.eclipse.papyrus.infra.emf.types.constraints.RelationshipConstraint;
import org.eclipse.papyrus.infra.emf.types.constraints.impl.AnyReferenceImpl;
import org.eclipse.papyrus.infra.emf.types.constraints.impl.CompositeConstraintImpl;
import org.eclipse.papyrus.infra.emf.types.constraints.impl.ConstraintAdviceConfigurationImpl;
import org.eclipse.papyrus.infra.emf.types.constraints.impl.ElementTypeFilterImpl;
import org.eclipse.papyrus.infra.emf.types.constraints.impl.EndPermissionImpl;
import org.eclipse.papyrus.infra.emf.types.constraints.impl.ReferenceConstraintImpl;
import org.eclipse.papyrus.infra.emf.types.constraints.impl.ReferenceImpl;
import org.eclipse.papyrus.infra.emf.types.constraints.impl.RelationshipConstraintImpl;

public class ConstraintAdviceFactoryImpl
extends EFactoryImpl
implements ConstraintAdviceFactory {
    public static ConstraintAdviceFactory init() {
        try {
            ConstraintAdviceFactory theConstraintAdviceFactory = (ConstraintAdviceFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/Papyrus/2021/types/constraints");
            if (theConstraintAdviceFactory != null) {
                return theConstraintAdviceFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new ConstraintAdviceFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createConstraintAdviceConfiguration();
            }
            case 2: {
                return this.createCompositeConstraint();
            }
            case 3: {
                return this.createReferenceConstraint();
            }
            case 5: {
                return this.createAnyReference();
            }
            case 6: {
                return this.createReference();
            }
            case 7: {
                return this.createElementTypeFilter();
            }
            case 8: {
                return this.createRelationshipConstraint();
            }
            case 9: {
                return this.createEndPermission();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 10: {
                return this.createReferenceKindFromString(eDataType, initialValue);
            }
            case 11: {
                return this.createElementTypeRelationshipKindFromString(eDataType, initialValue);
            }
            case 12: {
                return this.createEndKindFromString(eDataType, initialValue);
            }
            case 13: {
                return this.createEditCommandRequestFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 10: {
                return this.convertReferenceKindToString(eDataType, instanceValue);
            }
            case 11: {
                return this.convertElementTypeRelationshipKindToString(eDataType, instanceValue);
            }
            case 12: {
                return this.convertEndKindToString(eDataType, instanceValue);
            }
            case 13: {
                return this.convertEditCommandRequestToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public ConstraintAdviceConfiguration createConstraintAdviceConfiguration() {
        ConstraintAdviceConfigurationImpl constraintAdviceConfiguration = new ConstraintAdviceConfigurationImpl();
        return constraintAdviceConfiguration;
    }

    @Override
    public ReferenceConstraint createReferenceConstraint() {
        ReferenceConstraintImpl referenceConstraint = new ReferenceConstraintImpl();
        return referenceConstraint;
    }

    @Override
    public AnyReference createAnyReference() {
        AnyReferenceImpl anyReference = new AnyReferenceImpl();
        return anyReference;
    }

    @Override
    public Reference createReference() {
        ReferenceImpl reference = new ReferenceImpl();
        return reference;
    }

    @Override
    public ElementTypeFilter createElementTypeFilter() {
        ElementTypeFilterImpl elementTypeFilter = new ElementTypeFilterImpl();
        return elementTypeFilter;
    }

    @Override
    public RelationshipConstraint createRelationshipConstraint() {
        RelationshipConstraintImpl relationshipConstraint = new RelationshipConstraintImpl();
        return relationshipConstraint;
    }

    @Override
    public EndPermission createEndPermission() {
        EndPermissionImpl endPermission = new EndPermissionImpl();
        return endPermission;
    }

    @Override
    public CompositeConstraint createCompositeConstraint() {
        CompositeConstraintImpl compositeConstraint = new CompositeConstraintImpl();
        return compositeConstraint;
    }

    public ReferenceKind createReferenceKindFromString(EDataType eDataType, String initialValue) {
        ReferenceKind result = ReferenceKind.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertReferenceKindToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public ElementTypeRelationshipKind createElementTypeRelationshipKindFromString(EDataType eDataType, String initialValue) {
        ElementTypeRelationshipKind result = ElementTypeRelationshipKind.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertElementTypeRelationshipKindToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public EndKind createEndKindFromString(EDataType eDataType, String initialValue) {
        EndKind result = EndKind.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertEndKindToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public IEditCommandRequest createEditCommandRequestFromString(EDataType eDataType, String initialValue) {
        return (IEditCommandRequest)super.createFromString(eDataType, initialValue);
    }

    public String convertEditCommandRequestToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    @Override
    public ConstraintAdvicePackage getConstraintAdvicePackage() {
        return (ConstraintAdvicePackage)this.getEPackage();
    }

    @Deprecated
    public static ConstraintAdvicePackage getPackage() {
        return ConstraintAdvicePackage.eINSTANCE;
    }
}

