/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.groups.core.groupcontainment;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.groups.groupcontainment.AbstractContainerNodeDescriptor;

public class GroupContainmentRegistry {
    private static final String GROUP_EXTENSION_POINT = "org.eclipse.papyrus.uml.diagram.common.groups.groupcontainment";
    private static final String MODEL_CONTAINER_NODE = "modelContainer";
    private static final String REFERENCE_CONTAINER_NODE = "referenceContainer";
    private static final String CONTAINER_DESCRIPTOR_ATTRIBUTE = "descriptor";
    private static final String EDIT_PART_TYPE_ATTRIBUTE = "editPartType";
    private static Map<String, AbstractContainerNodeDescriptor> modelContainersDescriptors = new HashMap<String, AbstractContainerNodeDescriptor>();
    private static Map<String, AbstractContainerNodeDescriptor> graphicalContainersDescriptors = new HashMap<String, AbstractContainerNodeDescriptor>();
    private static Map<String, AbstractContainerNodeDescriptor> descriptorForViewType = new HashMap<String, AbstractContainerNodeDescriptor>();

    static {
        GroupContainmentRegistry.initialize();
    }

    public static void initialize() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(GROUP_EXTENSION_POINT);
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String editPartType;
                IConfigurationElement providing = iConfigurationElementArray[n4];
                if (MODEL_CONTAINER_NODE.equals(providing.getName())) {
                    editPartType = providing.getAttribute(EDIT_PART_TYPE_ATTRIBUTE);
                    if (editPartType != null) {
                        try {
                            provider = providing.createExecutableExtension(CONTAINER_DESCRIPTOR_ATTRIBUTE);
                            if (provider instanceof AbstractContainerNodeDescriptor) {
                                modelContainersDescriptors.put(editPartType, (AbstractContainerNodeDescriptor)provider);
                            }
                        }
                        catch (CoreException provider) {}
                    }
                } else if (REFERENCE_CONTAINER_NODE.equals(providing.getName()) && (editPartType = providing.getAttribute(EDIT_PART_TYPE_ATTRIBUTE)) != null) {
                    try {
                        provider = providing.createExecutableExtension(CONTAINER_DESCRIPTOR_ATTRIBUTE);
                        if (provider instanceof AbstractContainerNodeDescriptor) {
                            graphicalContainersDescriptors.put(editPartType, (AbstractContainerNodeDescriptor)provider);
                        }
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    public static Set<AbstractContainerNodeDescriptor> getDescriptorsWithContainerEClass(EClass containerEClass) {
        HashSet<AbstractContainerNodeDescriptor> descriptors = new HashSet<AbstractContainerNodeDescriptor>(modelContainersDescriptors.size() + graphicalContainersDescriptors.size());
        HashSet<AbstractContainerNodeDescriptor> descriptorsResult = new HashSet<AbstractContainerNodeDescriptor>(modelContainersDescriptors.size() + graphicalContainersDescriptors.size());
        descriptors.addAll(modelContainersDescriptors.values());
        descriptors.addAll(graphicalContainersDescriptors.values());
        for (AbstractContainerNodeDescriptor descriptor : descriptors) {
            if (!descriptor.getContainerEClass().equals(containerEClass)) continue;
            descriptorsResult.add(descriptor);
        }
        return descriptorsResult;
    }

    public static Set<EReference> getAllERefencesFromNodeToGroup() {
        HashSet<EReference> referencesResult = new HashSet<EReference>();
        HashSet<AbstractContainerNodeDescriptor> descriptors = new HashSet<AbstractContainerNodeDescriptor>(modelContainersDescriptors.size() + graphicalContainersDescriptors.size());
        descriptors.addAll(modelContainersDescriptors.values());
        descriptors.addAll(graphicalContainersDescriptors.values());
        for (AbstractContainerNodeDescriptor descriptor : descriptors) {
            for (EReference ref : descriptor.getChildrenReferences()) {
                EReference eoppositeRef = ref.getEOpposite();
                if (eoppositeRef == null) continue;
                referencesResult.add(eoppositeRef);
            }
        }
        return referencesResult;
    }

    public static boolean isContainerConcerned(IGraphicalEditPart editPart) {
        if (editPart == null) {
            return false;
        }
        String editPartClassName = editPart.getClass().getCanonicalName();
        return modelContainersDescriptors.containsKey(editPartClassName) || graphicalContainersDescriptors.containsKey(editPartClassName);
    }

    public static boolean isNodeConcerned(IGraphicalEditPart editPart) {
        EClass current = editPart.resolveSemanticElement().eClass();
        HashSet<EReference> allReferences = new HashSet<EReference>();
        for (AbstractContainerNodeDescriptor nodeDesc1 : modelContainersDescriptors.values()) {
            allReferences.addAll(nodeDesc1.getChildrenReferences());
        }
        for (AbstractContainerNodeDescriptor nodeDesc2 : graphicalContainersDescriptors.values()) {
            allReferences.addAll(nodeDesc2.getChildrenReferences());
        }
        for (EReference ref : allReferences) {
            if (!ref.getEReferenceType().isSuperTypeOf(current)) continue;
            return true;
        }
        return false;
    }

    public static AbstractContainerNodeDescriptor getContainerDescriptor(IGraphicalEditPart editPart) {
        String editPartClassName = editPart.getClass().getCanonicalName();
        if (modelContainersDescriptors.containsKey(editPartClassName)) {
            return modelContainersDescriptors.get(editPartClassName);
        }
        if (graphicalContainersDescriptors.containsKey(editPartClassName)) {
            return graphicalContainersDescriptors.get(editPartClassName);
        }
        return null;
    }

    public static boolean isContainerModel(IGraphicalEditPart editPart) {
        String editPartClassName = editPart.getClass().getCanonicalName();
        return modelContainersDescriptors.containsKey(editPartClassName);
    }

    public static IGraphicalEditPart getGroupContainingPartFromView(View view, DiagramEditPart diagramPart) {
        IGraphicalEditPart res;
        String viewType = view.getType();
        if (descriptorForViewType.containsKey(viewType)) {
            AbstractContainerNodeDescriptor desc = descriptorForViewType.get(viewType);
            if (desc != null) {
                return desc.getPartFromView(view, diagramPart);
            }
            return null;
        }
        for (AbstractContainerNodeDescriptor desc : modelContainersDescriptors.values()) {
            res = desc.getPartFromView(view, diagramPart);
            if (res == null) continue;
            descriptorForViewType.put(viewType, desc);
            return res;
        }
        for (AbstractContainerNodeDescriptor desc : graphicalContainersDescriptors.values()) {
            res = desc.getPartFromView(view, diagramPart);
            if (res == null) continue;
            descriptorForViewType.put(viewType, desc);
            return res;
        }
        descriptorForViewType.put(viewType, null);
        return null;
    }
}

