/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.wizards.transformation;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.m2m.qvt.oml.BasicModelExtent;
import org.eclipse.m2m.qvt.oml.ExecutionContext;
import org.eclipse.m2m.qvt.oml.ExecutionContextImpl;
import org.eclipse.m2m.qvt.oml.ExecutionDiagnostic;
import org.eclipse.m2m.qvt.oml.ModelExtent;
import org.eclipse.m2m.qvt.oml.TransformationExecutor;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.uml.diagram.wizards.Activator;
import org.eclipse.papyrus.uml.diagram.wizards.command.CopyModelCommand;
import org.eclipse.papyrus.uml.diagram.wizards.transformation.IGenerator;
import org.eclipse.papyrus.uml.tools.model.UmlUtils;

public class QVToGenerator
implements IGenerator {
    protected ModelSet modelSet;
    protected String templateURI;
    protected String pluginID;
    protected static Map<URI, TransformationExecutor> executorMap = new HashMap<URI, TransformationExecutor>();
    protected TransformationExecutor executor;
    protected URI transformationURI;

    @Override
    public void execute() {
        this.setExecutor();
        if (this.executor == null) {
            return;
        }
        ExecutionContextImpl context = new ExecutionContextImpl();
        Resource inResource = UmlUtils.getUmlModel((ModelSet)this.getOutputModelSet()).getResource();
        EList inObjects = inResource.getContents();
        Resource inResourceTemplate = this.loadTemplateResource();
        EList inObjectTemplates = inResourceTemplate.getContents();
        BasicModelExtent input = new BasicModelExtent((List)inObjects);
        BasicModelExtent inputTemplate = new BasicModelExtent((List)inObjectTemplates);
        context.setConfigProperty("keepModeling", (Object)true);
        ExecutionDiagnostic result = this.executor.execute((ExecutionContext)context, new ModelExtent[]{inputTemplate, input});
        if (result.getSeverity() == 0) {
            List outObjects = input.getContents();
            this.getCommandStack(this.getOutputModelSet()).execute((Command)new CopyModelCommand(this.getOutputModelSet().getTransactionalEditingDomain(), inResource, outObjects));
            try {
                inResource.save(Collections.emptyMap());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            IStatus status = BasicDiagnostic.toIStatus((Diagnostic)result);
            Activator.getDefault().getLog().log(status);
        }
    }

    public void setTemplateModel(String templateURI) {
        this.templateURI = templateURI;
    }

    public ModelSet getOutputModelSet() {
        return this.modelSet;
    }

    @Override
    public void setModelSet(ModelSet modelSet) {
        this.modelSet = modelSet;
    }

    public void setPluginId(String pluginId) {
        this.pluginID = pluginId;
    }

    private Resource loadTemplateResource() {
        String fullUri;
        URI uri;
        Resource resource;
        URL templateURL = Platform.getBundle((String)this.pluginID).getResource(this.templateURI);
        if (templateURL != null && (resource = this.modelSet.getResource(uri = URI.createPlatformPluginURI((String)(this.pluginID + (fullUri = templateURL.getPath())), (boolean)true), true)).isLoaded()) {
            return resource;
        }
        return null;
    }

    protected final CommandStack getCommandStack(ModelSet modelSet) {
        return modelSet.getTransactionalEditingDomain().getCommandStack();
    }

    public void setTransformationURI(URI transformationURI) {
        this.transformationURI = transformationURI;
    }

    public void setExecutor() {
        TransformationExecutor executor = executorMap.get(this.transformationURI);
        if (executor == null) {
            executor = new TransformationExecutor(this.transformationURI);
            executorMap.put(this.transformationURI, executor);
        }
        this.executor = executor;
    }
}

