/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.layer;

import ca.odell.glazedlists.TreeList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.hideshow.RowHideShowLayer;
import org.eclipse.nebula.widgets.nattable.hideshow.command.MultiRowShowCommand;
import org.eclipse.nebula.widgets.nattable.hideshow.command.RowHideCommand;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.RowDeleteEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.RowInsertEvent;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.nebula.widgets.nattable.tree.ITreeRowModel;
import org.eclipse.nebula.widgets.nattable.tree.TreeLayer;
import org.eclipse.nebula.widgets.nattable.tree.command.TreeExpandToLevelCommand;
import org.eclipse.nebula.widgets.nattable.tree.painter.IndentedTreeImagePainter;
import org.eclipse.nebula.widgets.nattable.ui.binding.UiBindingRegistry;
import org.eclipse.papyrus.infra.nattable.configuration.PapyrusTreeLayerConfiguration;
import org.eclipse.papyrus.infra.nattable.manager.table.ITreeNattableModelManager;
import org.eclipse.papyrus.infra.nattable.manager.table.NattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.ITreeItemAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.TreeFillingConfiguration;
import org.eclipse.papyrus.infra.nattable.utils.NattableConfigAttributes;
import org.eclipse.papyrus.infra.nattable.utils.StyleUtils;

public class PapyrusTreeLayer
extends TreeLayer {
    private ITreeNattableModelManager tableManager;
    private TreeList<?> treeList;
    private ListEventListener<Object> listener;

    public PapyrusTreeLayer(IUniqueIndexLayer underlyingLayer, ITreeRowModel<?> treeRowModel, boolean useDefaultConfiguration) {
        super(underlyingLayer, treeRowModel, useDefaultConfiguration);
        this.addConfiguration((IConfiguration)new PapyrusTreeLayerConfiguration(this));
    }

    public PapyrusTreeLayer(IUniqueIndexLayer underlyingLayer, ITreeRowModel<?> treeRowModel, IndentedTreeImagePainter indentedTreeImagePainter, boolean useDefaultConfiguration) {
        super(underlyingLayer, treeRowModel, indentedTreeImagePainter, useDefaultConfiguration);
        this.addConfiguration((IConfiguration)new PapyrusTreeLayerConfiguration(this));
    }

    public PapyrusTreeLayer(IUniqueIndexLayer underlyingLayer, ITreeRowModel<?> treeRowModel, IndentedTreeImagePainter indentedTreeImagePainter) {
        super(underlyingLayer, treeRowModel, indentedTreeImagePainter);
        this.addConfiguration((IConfiguration)new PapyrusTreeLayerConfiguration(this));
    }

    public PapyrusTreeLayer(IUniqueIndexLayer underlyingLayer, ITreeRowModel<?> treeRowModel) {
        super(underlyingLayer, treeRowModel);
        this.addConfiguration((IConfiguration)new PapyrusTreeLayerConfiguration(this));
    }

    public void configure(IConfigRegistry configRegistry, UiBindingRegistry uiBindingRegistry) {
        super.configure(configRegistry, uiBindingRegistry);
        Object tmp = configRegistry.getConfigAttribute(NattableConfigAttributes.NATTABLE_MODEL_MANAGER_CONFIG_ATTRIBUTE, DisplayMode.NORMAL, new String[]{"nattable_model_manager_id"});
        Assert.isTrue((boolean)(tmp instanceof ITreeNattableModelManager));
        this.tableManager = (ITreeNattableModelManager)tmp;
        this.treeList = this.tableManager.getTreeList();
        this.addListListener();
    }

    protected void addListListener() {
        this.listener = new ListEventListener<Object>(){

            public void listChanged(ListEvent<Object> listChanges) {
                PapyrusTreeLayer.this.manageListEvent(listChanges);
            }
        };
        this.treeList.addListEventListener(this.listener);
    }

    private NattableModelManager getTableManager() {
        return (NattableModelManager)((Object)this.tableManager);
    }

    protected RowHideShowLayer getRowHideShowLayer() {
        if (this.getTableManager() != null && this.getTableManager().getBodyLayerStack() != null) {
            return this.getTableManager().getBodyLayerStack().getRowHideShowLayer();
        }
        return null;
    }

    protected void manageInsertEvent(int index, NatTable natTable, RowHideShowLayer rowHideShowLayer) {
        if (index != -1) {
            Object element;
            if (natTable != null) {
                RowInsertEvent event = new RowInsertEvent((ILayer)this, index);
                rowHideShowLayer.handleLayerEvent((ILayerEvent)event);
            }
            if (!((element = this.getTableManager().getRowElement(index)) instanceof IAxis)) {
                return;
            }
            Object representedElement = ((IAxis)element).getElement();
            if (representedElement instanceof TreeFillingConfiguration) {
                int realIndex;
                TreeFillingConfiguration conf = (TreeFillingConfiguration)representedElement;
                if (StyleUtils.getHiddenDepths(this.getTableManager()).contains(conf.getDepth()) && (realIndex = rowHideShowLayer.underlyingToLocalRowPosition((ILayer)natTable, index)) != -1) {
                    natTable.doCommand((ILayerCommand)new TreeExpandToLevelCommand(Integer.valueOf(this.tableManager.getRowElementsList().indexOf(element)), 1));
                    natTable.doCommand((ILayerCommand)new RowHideCommand((ILayer)rowHideShowLayer, realIndex));
                }
            }
        }
    }

    protected void manageUpdateEvent(int index, NatTable natTable, RowHideShowLayer hideShowLayer) {
    }

    protected void manageDeleteEvent(int index, NatTable natTable, RowHideShowLayer rowHideShowLayer) {
        if (index != -1) {
            RowDeleteEvent event = new RowDeleteEvent((ILayer)this, index);
            rowHideShowLayer.handleLayerEvent((ILayerEvent)event);
            Object element = this.getTableManager().getRowElement(index);
            if (!(element instanceof IAxis)) {
                return;
            }
            Object representedElement = ((IAxis)element).getElement();
            if (representedElement instanceof TreeFillingConfiguration) {
                int realIndex;
                TreeFillingConfiguration conf = (TreeFillingConfiguration)representedElement;
                if (StyleUtils.getHiddenDepths(this.getTableManager()).contains(conf.getDepth()) && (realIndex = rowHideShowLayer.underlyingToLocalRowPosition((ILayer)natTable, index)) != -1) {
                    natTable.doCommand((ILayerCommand)new MultiRowShowCommand(Collections.singletonList(realIndex)));
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void manageListEvent(ListEvent<Object> listChanges) {
        if (this.getTableManager() == null) {
            return;
        }
        rowHideShowLayer = this.getRowHideShowLayer();
        natTable = (NatTable)this.getTableManager().getAdapter(NatTable.class);
        if (rowHideShowLayer != null && natTable != null) ** GOTO lbl20
        return;
lbl-1000:
        // 1 sources

        {
            listChanges.next();
            index = listChanges.getIndex();
            switch (listChanges.getType()) {
                case 0: {
                    this.manageDeleteEvent(index, natTable, rowHideShowLayer);
                    break;
                }
                case 1: {
                    this.manageUpdateEvent(index, natTable, rowHideShowLayer);
                    break;
                }
                case 2: {
                    this.manageInsertEvent(index, natTable, rowHideShowLayer);
                    break;
                }
            }
lbl20:
            // 5 sources

            ** while (listChanges.hasNext())
        }
lbl21:
        // 1 sources

        this.getTableManager().refreshNatTable();
    }

    public LabelStack getConfigLabelsByPosition(int columnPosition, int rowPosition) {
        Object value;
        LabelStack configLabels = super.getConfigLabelsByPosition(0, rowPosition);
        ILayerCell cell = this.getCellByPosition(columnPosition, rowPosition);
        if (cell != null && ((value = cell.getDataValue()) == null || "".equals(value))) {
            configLabels.removeLabel("TREE_DEPTH_");
            configLabels.removeLabel("TREE_LEAF");
            configLabels.removeLabel("TREE_COLLAPSED");
            configLabels.removeLabel("TREE_EXPANDED");
        }
        return configLabels;
    }

    public boolean doCommand(ILayerCommand command) {
        return super.doCommand(command);
    }

    public void expandOrCollapseIndex(int parentIndex) {
        super.expandOrCollapseIndex(parentIndex);
    }

    public void collapseTreeRow(int parentIndex) {
        super.collapseTreeRow(parentIndex);
    }

    public void expandTreeRow(int parentIndex) {
        int deth;
        List<Integer> hidden;
        ITreeItemAxis curr;
        if (this.tableManager == null) {
            return;
        }
        Object expandedEl = this.tableManager.getRowElementsList().get(parentIndex);
        super.expandTreeRow(parentIndex);
        if (expandedEl instanceof ITreeItemAxis && !((curr = (ITreeItemAxis)expandedEl).getElement() instanceof TreeFillingConfiguration) && !curr.getChildren().isEmpty() && (hidden = StyleUtils.getHiddenDepths(this.tableManager)).contains(deth = this.tableManager.getSemanticDepth(curr) + 1)) {
            for (ITreeItemAxis child : curr.getChildren()) {
                int childIndex = this.tableManager.getRowElementsList().indexOf(child);
                this.expandTreeRow(childIndex);
            }
        }
    }

    public void dispose() {
        this.treeList.removeListEventListener(this.listener);
        this.treeList = null;
        this.tableManager = null;
        super.dispose();
    }
}

