/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.layer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.copy.command.CopyDataCommandHandler;
import org.eclipse.nebula.widgets.nattable.copy.command.CopyDataToClipboardCommand;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.selection.ISelectionModel;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.papyrus.infra.nattable.selection.PapyrusSelectColumnCommandHandler;
import org.eclipse.papyrus.infra.nattable.selection.PapyrusSelectRowCommandHandler;
import org.eclipse.swt.graphics.Rectangle;

public class PapyrusSelectionLayer
extends SelectionLayer {
    public PapyrusSelectionLayer(IUniqueIndexLayer underlyingLayer, boolean useDefaultConfiguration) {
        super(underlyingLayer, useDefaultConfiguration);
    }

    public PapyrusSelectionLayer(IUniqueIndexLayer underlyingLayer, ISelectionModel selectionModel, boolean useDefaultConfiguration) {
        super(underlyingLayer, selectionModel, useDefaultConfiguration);
    }

    public PapyrusSelectionLayer(IUniqueIndexLayer underlyingLayer) {
        super(underlyingLayer);
    }

    protected void registerCommandHandlers() {
        this.selectRowCommandHandler = new PapyrusSelectRowCommandHandler(this);
        this.selectColumnCommandHandler = new PapyrusSelectColumnCommandHandler(this);
        super.registerCommandHandlers();
        this.unregisterCommandHandler(CopyDataToClipboardCommand.class);
        CopyDataCommandHandler handler = new CopyDataCommandHandler((SelectionLayer)this);
        handler.setCopyFormattedText(true);
        this.registerCommandHandler((ILayerCommandHandler)handler);
    }

    public void setLastSelectedRegion(Rectangle region) {
        super.setLastSelectedRegion(region);
    }

    public List<Range> getRangeSelectedAxis(Collection<Integer> positions) {
        ArrayList<Range> selectedRange = new ArrayList<Range>();
        for (int position : positions) {
            Iterator existingRangesIterator = selectedRange.iterator();
            boolean found = false;
            while (!found && existingRangesIterator.hasNext()) {
                Range existingRange = (Range)existingRangesIterator.next();
                if (existingRange.start - 1 == position) {
                    existingRange.start = position;
                    found = true;
                    continue;
                }
                if (existingRange.end != position) continue;
                existingRange.end = position + 1;
                found = true;
            }
            if (found) continue;
            selectedRange.add(new Range(position, position + 1));
        }
        return selectedRange;
    }

    public IUniqueIndexLayer getSelectionUnderlyingLayer() {
        return this.underlyingLayer;
    }
}

