/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.appearance.style;

import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.emf.appearance.commands.SetNameLabelIconCommand;
import org.eclipse.papyrus.infra.emf.appearance.commands.SetQualifiedNameDepthCommand;
import org.eclipse.papyrus.infra.emf.appearance.commands.SetShadowFigureCommand;
import org.eclipse.papyrus.infra.emf.appearance.style.AppearanceStyleProvider;

public class AnnotationStyleProvider
implements AppearanceStyleProvider {
    @Override
    public boolean showElementIcon(EModelElement modelElement) {
        String gradientvalueString;
        EMap entries;
        EAnnotation displayNameLabelIcon = modelElement.getEAnnotation("displayNameLabelIcon");
        if (displayNameLabelIcon != null && (entries = displayNameLabelIcon.getDetails()) != null && (gradientvalueString = (String)entries.get((Object)"displayNameLabelIcon_value")) != null) {
            return new Boolean(gradientvalueString);
        }
        return false;
    }

    @Override
    public int getQualifiedNameDepth(EModelElement modelElement) {
        String depthString;
        EMap entries;
        EAnnotation qualifiedNameAnnotation = modelElement.getEAnnotation("QualifiedName");
        if (qualifiedNameAnnotation != null && (entries = qualifiedNameAnnotation.getDetails()) != null && (depthString = (String)entries.get((Object)"QualifiedNameDepth")) != null) {
            return new Integer(depthString);
        }
        return 1000;
    }

    @Override
    public boolean showShadow(EModelElement modelElement) {
        String gradientvalueString;
        EMap entries;
        EAnnotation shadowAnnotation = modelElement.getEAnnotation("ShadowFigure");
        if (shadowAnnotation != null && (entries = shadowAnnotation.getDetails()) != null && (gradientvalueString = (String)entries.get((Object)"ShadowFigure_Value")) != null) {
            return new Boolean(gradientvalueString);
        }
        return false;
    }

    public static RecordingCommand getSetElementIconCommand(TransactionalEditingDomain domain, EModelElement view, boolean nameLabelIconValue) {
        return new SetNameLabelIconCommand(domain, view, nameLabelIconValue);
    }

    public static RecordingCommand getSetQualifiedNameDepthCommand(TransactionalEditingDomain domain, EModelElement view, int depth) {
        return new SetQualifiedNameDepthCommand(domain, view, depth);
    }

    public static RecordingCommand getSetShadowCommand(TransactionalEditingDomain domain, EModelElement view, boolean shadowFigureValue) {
        return new SetShadowFigureCommand(domain, view, shadowFigureValue);
    }
}

