/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.types.core.utils;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.IEditHelperAdvice;
import org.eclipse.papyrus.infra.types.core.registries.ElementTypeSetConfigurationRegistry;
import org.eclipse.papyrus.infra.types.core.utils.OrientedGraph;

public class AdviceUtil {
    public static IEditHelperAdvice[] sort(IEditHelperAdvice[] advices, IElementType[] types, String contextId) {
        ArrayList<OrientedGraph<String>> dependencies = new ArrayList<OrientedGraph<String>>();
        IElementType[] iElementTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IElementType iElementType = iElementTypeArray[n2];
            dependencies.add(ElementTypeSetConfigurationRegistry.getInstance().getAdvicesDeps(iElementType.getId(), contextId));
            ++n2;
        }
        return AdviceUtil.sort(advices, dependencies);
    }

    public static IEditHelperAdvice[] sort(IEditHelperAdvice[] advices, IElementType elementType, String contextId) {
        IElementType[] supertypes = elementType.getAllSuperTypes();
        IElementType[] allTypes = Arrays.copyOf(supertypes, supertypes.length + 1);
        allTypes[supertypes.length] = elementType;
        return AdviceUtil.sort(advices, allTypes, contextId);
    }

    private static IEditHelperAdvice[] sort(IEditHelperAdvice[] advices, Collection<OrientedGraph<String>> dependencies) {
        IEditHelperAdvice advice;
        OrientedGraph<String> graph = AdviceUtil.mergeGraph(dependencies);
        if (graph == null) {
            return advices;
        }
        LinkedHashSet<IEditHelperAdvice> sortedAdvices = new LinkedHashSet<IEditHelperAdvice>();
        HashMultimap idToAdvice = HashMultimap.create();
        IEditHelperAdvice[] iEditHelperAdviceArray = advices;
        int n = advices.length;
        int n2 = 0;
        while (n2 < n) {
            advice = iEditHelperAdviceArray[n2];
            idToAdvice.put((Object)AdviceUtil.getId(advice), (Object)advice);
            ++n2;
        }
        iEditHelperAdviceArray = advices;
        n = advices.length;
        n2 = 0;
        while (n2 < n) {
            advice = iEditHelperAdviceArray[n2];
            AdviceUtil.collectSortedDependencies(advice, graph, (Multimap<String, IEditHelperAdvice>)idToAdvice, sortedAdvices);
            ++n2;
        }
        return sortedAdvices.toArray(advices);
    }

    private static String getId(IEditHelperAdvice advice) {
        return advice == null ? null : advice.getClass().getName();
    }

    private static void collectSortedDependencies(IEditHelperAdvice advice, OrientedGraph<String> dependencies, Multimap<String, IEditHelperAdvice> idToAdvice, LinkedHashSet<IEditHelperAdvice> result) {
        if (advice != null && result.contains(advice)) {
            return;
        }
        String adviceName = AdviceUtil.getId(advice);
        Set<String> allDependencies = dependencies.getAllConnex(adviceName);
        for (String dependencyID : allDependencies) {
            for (IEditHelperAdvice dependency : idToAdvice.get((Object)dependencyID)) {
                AdviceUtil.collectSortedDependencies(dependency, dependencies, idToAdvice, result);
            }
        }
        if (advice != null) {
            result.add(advice);
        }
    }

    private static <T> OrientedGraph<T> mergeGraph(Collection<OrientedGraph<T>> graphs) {
        OrientedGraph<T> result = null;
        for (OrientedGraph<T> graph : graphs) {
            if (result == null) {
                result = graph;
                continue;
            }
            for (Map.Entry<T, Set<T>> edge : graph.getEdges().entrySet()) {
                T source = edge.getKey();
                for (T target : edge.getValue()) {
                    result.addEdge(source, target);
                }
            }
        }
        return result;
    }
}

