/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.readonly.internal;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomainEvent;
import org.eclipse.emf.transaction.TransactionalEditingDomainListener;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.papyrus.infra.emf.readonly.internal.LocaleUtil;

public class ControlledResourceTracker
extends AdapterImpl
implements TransactionalEditingDomainListener {
    private volatile ListMultimap<URI, URI> unitMap = ArrayListMultimap.create();
    private volatile ListMultimap<URI, URI> pending;

    public static ControlledResourceTracker getInstance(EditingDomain domain) {
        ControlledResourceTracker result = null;
        for (Object next : domain.getResourceSet().eAdapters()) {
            if (!(next instanceof ControlledResourceTracker)) continue;
            result = (ControlledResourceTracker)((Object)next);
            break;
        }
        if (result == null) {
            result = new ControlledResourceTracker(domain);
        }
        return result;
    }

    private ControlledResourceTracker(EditingDomain domain) {
        domain.getResourceSet().eAdapters().add((Object)this);
        if (domain instanceof TransactionalEditingDomain) {
            ((TransactionalEditingDomain.Lifecycle)TransactionUtil.getAdapter((TransactionalEditingDomain)((TransactionalEditingDomain)domain), TransactionalEditingDomain.Lifecycle.class)).addTransactionalEditingDomainListener((TransactionalEditingDomainListener)this);
        }
        this.commit();
    }

    public Set<URI> getRootResourceURIs(URI uri) {
        HashSet result = Sets.newHashSet();
        LinkedList units = Lists.newLinkedList();
        units.add(uri.trimFileExtension());
        URI next = (URI)units.poll();
        while (next != null) {
            if (this.isRoot(next)) {
                result.add(this.getFinalURI(uri, next));
            } else {
                Iterables.addAll((Collection)units, this.get(next));
            }
            next = (URI)units.poll();
        }
        return result;
    }

    private URI getFinalURI(URI uri, URI initialURI) {
        String withoutLocalization;
        String lastSegment;
        URI result = initialURI;
        if (uri != null && uri.fileExtension() != null && uri.fileExtension().equals("properties") && !(lastSegment = initialURI.lastSegment()).equals(withoutLocalization = LocaleUtil.trimLocalization(lastSegment))) {
            result = initialURI.trimSegments(1);
            result = result.appendSegment(withoutLocalization);
        }
        return result;
    }

    private boolean isRoot(URI uriWithoutFileExtension) {
        return !(this.unitMap.containsKey((Object)uriWithoutFileExtension) && !this.unitMap.get((Object)uriWithoutFileExtension).isEmpty() || this.pending != null && this.pending.containsKey((Object)uriWithoutFileExtension) && !this.pending.get((Object)uriWithoutFileExtension).isEmpty());
    }

    private Iterable<URI> get(URI potentialUnit) {
        List result = null;
        if (this.unitMap.containsKey((Object)potentialUnit)) {
            result = this.unitMap.get((Object)potentialUnit);
        } else if (this.pending != null) {
            result = this.pending.get((Object)potentialUnit);
        }
        return result;
    }

    private void ensurePending() {
        if (this.pending == null) {
            this.pending = ArrayListMultimap.create(this.unitMap);
        }
    }

    private void map(URI controlledUnit, URI parentUnit) {
        this.ensurePending();
        this.pending.put((Object)controlledUnit.trimFileExtension(), (Object)parentUnit.trimFileExtension());
    }

    private void unmap(URI controlledUnit, URI parentUnit) {
        this.ensurePending();
        this.pending.remove((Object)controlledUnit.trimFileExtension(), (Object)parentUnit.trimFileExtension());
    }

    private void commit() {
        if (this.pending != null) {
            this.unitMap = this.pending;
            this.pending = null;
        }
    }

    private void rollback() {
        this.pending = null;
    }

    public void setTarget(Notifier newTarget) {
        if (newTarget instanceof ResourceSet) {
            for (Resource next : ((ResourceSet)newTarget).getResources()) {
                this.addAdapter((Notifier)next);
            }
        } else if (newTarget instanceof Resource) {
            this.handleResource((Resource)newTarget);
        }
    }

    protected void addAdapter(Notifier notifier) {
        notifier.eAdapters().add((Object)this);
    }

    protected void removeAdapter(Notifier notifier) {
        notifier.eAdapters().remove((Object)this);
    }

    public void unsetTarget(Notifier oldTarget) {
        if (oldTarget instanceof ResourceSet) {
            for (Resource next : ((ResourceSet)oldTarget).getResources()) {
                this.removeAdapter((Notifier)next);
            }
        }
    }

    protected void handleResource(Resource resource) {
        if (!resource.getContents().isEmpty()) {
            for (EObject root : resource.getContents()) {
                this.handleAdd(resource, root);
            }
        }
    }

    protected void handleAdd(Resource resource, EObject newRoot) {
        InternalEObject container = ((InternalEObject)newRoot).eInternalContainer();
        if (container != null) {
            URI parentURI;
            URI uRI = parentURI = container.eIsProxy() ? container.eProxyURI().trimFragment() : container.eResource().getURI();
            if (parentURI != null) {
                this.map(resource.getURI(), parentURI);
            }
        }
    }

    protected void handleRemove(Resource resource, EObject oldRoot) {
        InternalEObject container = ((InternalEObject)oldRoot).eInternalContainer();
        if (container != null) {
            URI parentURI;
            URI uRI = parentURI = container.eIsProxy() ? container.eProxyURI().trimFragment() : container.eResource().getURI();
            if (parentURI != null) {
                this.unmap(resource.getURI(), parentURI);
            }
        }
    }

    public void handleCrossResourceContainment(InternalEObject crossResourceContained) {
        URI parentURI;
        URI resourceURI = crossResourceContained.eIsProxy() ? crossResourceContained.eProxyURI().trimFragment() : crossResourceContained.eDirectResource().getURI();
        InternalEObject container = crossResourceContained.eInternalContainer();
        URI uRI = parentURI = container.eIsProxy() ? container.eProxyURI().trimFragment() : container.eResource().getURI();
        if (parentURI != null) {
            this.map(resourceURI, parentURI);
        }
    }

    public void notifyChanged(Notification msg) {
        block25: {
            Object notifier;
            block24: {
                notifier = msg.getNotifier();
                if (!(notifier instanceof ResourceSet)) break block24;
                block0 : switch (msg.getFeatureID(ResourceSet.class)) {
                    case 0: {
                        switch (msg.getEventType()) {
                            case 3: {
                                this.addAdapter((Notifier)((Resource)msg.getNewValue()));
                                break block0;
                            }
                            case 5: {
                                for (Object next : (Collection)msg.getNewValue()) {
                                    this.addAdapter((Notifier)((Resource)next));
                                }
                                break block25;
                            }
                            case 1: {
                                this.removeAdapter((Notifier)((Resource)msg.getOldValue()));
                                this.addAdapter((Notifier)((Resource)msg.getNewValue()));
                                break block0;
                            }
                            case 4: {
                                this.removeAdapter((Notifier)((Resource)msg.getOldValue()));
                                break block0;
                            }
                            case 6: {
                                for (Object next : (Collection)msg.getOldValue()) {
                                    this.removeAdapter((Notifier)((Resource)next));
                                }
                            }
                        }
                    }
                }
                break block25;
            }
            if (!(notifier instanceof Resource)) break block25;
            Resource resource = (Resource)notifier;
            block10 : switch (msg.getFeatureID(Resource.class)) {
                case 2: {
                    switch (msg.getEventType()) {
                        case 3: {
                            this.handleAdd(resource, (EObject)msg.getNewValue());
                            break block10;
                        }
                        case 5: {
                            for (Object next : (Iterable)msg.getNewValue()) {
                                this.handleAdd(resource, (EObject)next);
                            }
                            break block25;
                        }
                        case 1: {
                            this.handleRemove(resource, (EObject)msg.getOldValue());
                            this.handleAdd(resource, (EObject)msg.getNewValue());
                            break block10;
                        }
                        case 4: {
                            this.handleRemove(resource, (EObject)msg.getOldValue());
                            break block10;
                        }
                        case 6: {
                            for (Object next : (Iterable)msg.getOldValue()) {
                                this.handleRemove(resource, (EObject)next);
                            }
                        }
                    }
                }
            }
        }
    }

    public void transactionClosed(TransactionalEditingDomainEvent event) {
        if (event.getTransaction().getStatus().getSeverity() >= 4) {
            this.rollback();
        } else {
            this.commit();
        }
    }

    public void editingDomainDisposing(TransactionalEditingDomainEvent event) {
        this.removeAdapter((Notifier)event.getSource().getResourceSet());
    }

    public void transactionStarting(TransactionalEditingDomainEvent event) {
    }

    public void transactionInterrupted(TransactionalEditingDomainEvent event) {
    }

    public void transactionStarted(TransactionalEditingDomainEvent event) {
    }

    public void transactionClosing(TransactionalEditingDomainEvent event) {
    }
}

