/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.providers;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.infra.widgets.editors.StringWithClearEditor;
import org.eclipse.papyrus.infra.widgets.messages.Messages;
import org.eclipse.papyrus.infra.widgets.providers.EncapsulatedContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.PatternViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class FilteredContentProvider
extends EncapsulatedContentProvider {
    protected StructuredViewer viewer;
    private StringWithClearEditor filterPattern;
    public static final String BASE_PATTERN = "*";
    protected boolean showIfHasVisibleParent = false;
    private static final String ICONS_EXPAND_ALL = "/icons/expandAll.png";
    private static final String ICONS_COLLAPSE_ALL = "/icons/collapseAll.png";
    private ToolItem buttonExpand;
    private ToolItem buttonCollapse;
    private PatternViewerFilter patternFilter;
    private String currentFilterPattern;
    private boolean buttonExpandCollapseEnable = true;

    public FilteredContentProvider(IStructuredContentProvider encapsulated) {
        super(encapsulated);
    }

    public FilteredContentProvider() {
    }

    @Override
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        super.inputChanged(viewer, oldInput, newInput);
        if (viewer instanceof StructuredViewer) {
            this.viewer = (StructuredViewer)viewer;
            this.checkPatterns();
        }
    }

    @Override
    public void createBefore(Composite parent) {
        super.createBefore(parent);
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        this.createFilterPattern(composite);
        this.findAndRevealFirstMatchingItem();
        this.createCaseSensitiveButton(composite);
    }

    @Override
    public void createViewerToolbar(Composite parent) {
        if (!this.isFlat()) {
            this.createExpandCollapseButtons(parent);
        }
    }

    protected void createExpandCollapseButtons(Composite parent) {
        ToolBar Toolbar = new ToolBar(parent, 0);
        this.buttonExpand = new ToolItem(Toolbar, 0);
        this.buttonExpand.setImage(Activator.getDefault().getImage(ICONS_EXPAND_ALL));
        this.buttonExpand.setToolTipText(Messages.FilteredContentProvider_ExpandAllTooltip);
        this.buttonExpand.setEnabled(this.buttonExpandCollapseEnable);
        this.buttonExpand.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ISelection selection = FilteredContentProvider.this.viewer.getSelection();
                if (selection instanceof StructuredSelection && !selection.isEmpty()) {
                    Object[] objectArray = ((StructuredSelection)selection).toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object object = objectArray[n2];
                        ((AbstractTreeViewer)FilteredContentProvider.this.viewer).expandToLevel(object, Activator.getMaxLevelToExpandValue());
                        ++n2;
                    }
                } else {
                    ((AbstractTreeViewer)FilteredContentProvider.this.viewer).expandToLevel(Activator.getMaxLevelToExpandValue());
                }
            }
        });
        this.buttonCollapse = new ToolItem(Toolbar, 0);
        this.buttonCollapse.setImage(Activator.getDefault().getImage(ICONS_COLLAPSE_ALL));
        this.buttonCollapse.setToolTipText(Messages.FilteredContentProvider_CollapseAllTooltip);
        this.buttonCollapse.setEnabled(this.buttonExpandCollapseEnable);
        this.buttonCollapse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ISelection selection = ((AbstractTreeViewer)FilteredContentProvider.this.viewer).getSelection();
                if (selection instanceof StructuredSelection && !selection.isEmpty()) {
                    Object[] objectArray = ((StructuredSelection)selection).toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object object = objectArray[n2];
                        ((AbstractTreeViewer)FilteredContentProvider.this.viewer).collapseToLevel(object, -1);
                        ++n2;
                    }
                } else {
                    ((AbstractTreeViewer)FilteredContentProvider.this.viewer).collapseAll();
                }
            }
        });
    }

    protected void createFilterPattern(Composite composite) {
        this.filterPattern = new StringWithClearEditor(composite, 2048);
        this.filterPattern.setLayoutData(new GridData(4, 0, true, false));
        this.filterPattern.setValidateOnDelay(Activator.getValidationDelay());
        this.filterPattern.setValidateOnDelay(Activator.isFilterValidateOnDelay());
        if (Activator.isStereotypeDelimitersReplaced()) {
            this.filterPattern.addStringToReplace("<<", "\u00ab");
            this.filterPattern.addStringToReplace(">>", "\u00bb");
        } else {
            this.filterPattern.clearStringToReplace();
        }
        this.currentFilterPattern = BASE_PATTERN;
        this.patternFilter = this.getViewerFilter();
        this.patternFilter.setPattern(this.currentFilterPattern);
        this.filterPattern.addCommitListener(editor -> {
            String filterPattern = ((StringWithClearEditor)editor).getValue();
            this.patternFilter.setPattern(filterPattern);
            this.checkPatterns();
            if (!"".equals(filterPattern) && !this.currentFilterPattern.equals(filterPattern)) {
                this.findAndRevealFirstMatchingItem();
                this.currentFilterPattern = filterPattern;
            }
        });
    }

    protected Object findAndRevealFirstMatchingItem() {
        Tree tree;
        Object result = null;
        if (this.viewer instanceof TreeViewer && (tree = ((TreeViewer)this.viewer).getTree()).getItems().length > 0) {
            result = this.revealFirstLeaf(tree.getItem(0), 15);
        }
        return result;
    }

    private Object revealFirstLeaf(TreeItem item, int maxSearchDepth) {
        Object result = null;
        if (1 <= maxSearchDepth && this.viewer instanceof TreeViewer) {
            TreeViewer treeViewer = (TreeViewer)this.viewer;
            Object[] itemDataArray = Collections.singletonList(item.getData()).toArray();
            treeViewer.setExpandedElements(itemDataArray);
            if (item.getItems().length > 0) {
                result = this.revealFirstLeaf(item.getItem(0), maxSearchDepth - 1);
            } else {
                result = item.getData();
                treeViewer.setSelection((ISelection)new StructuredSelection(result));
            }
        }
        return result;
    }

    protected void createCaseSensitiveButton(Composite parent) {
        Button checkBoxCaseSensitive = new Button(parent, 32);
        checkBoxCaseSensitive.setText(Messages.FilteredContentProvider_CaseSensitiveLabel);
        checkBoxCaseSensitive.setToolTipText(Messages.FilteredContentProvider_CaseSensitiveTooltip);
        checkBoxCaseSensitive.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (FilteredContentProvider.this.patternFilter instanceof PatternViewerFilter) {
                    FilteredContentProvider.this.patternFilter.setIgnoreCase(!((Button)event.getSource()).getSelection());
                }
                FilteredContentProvider.this.viewer.refresh();
            }
        });
    }

    protected PatternViewerFilter getViewerFilter() {
        PatternViewerFilter filter = new PatternViewerFilter();
        filter.setStrict(false);
        filter.setPattern(BASE_PATTERN);
        filter.setShowIfHasVisibleParent(this.showIfHasVisibleParent);
        return filter;
    }

    protected void checkPatterns() {
        if (this.viewer instanceof TreeViewer && this.viewer.getInput() != null) {
            List<ViewerFilter> filtersAsList = Arrays.asList(this.viewer.getFilters());
            if (this.patternFilter != null && !filtersAsList.contains((Object)this.patternFilter)) {
                this.viewer.addFilter((ViewerFilter)this.patternFilter);
            }
            this.viewer.refresh();
        }
    }

    @Override
    public void setFlat(boolean flat) {
        super.setFlat(flat);
        if (this.patternFilter instanceof PatternViewerFilter) {
            this.patternFilter.clearCache();
            this.viewer.refresh();
        }
        if (this.buttonCollapse != null && this.buttonExpand != null) {
            this.buttonExpandCollapseEnable = !flat;
            this.buttonCollapse.setEnabled(this.buttonExpandCollapseEnable);
            this.buttonExpand.setEnabled(this.buttonExpandCollapseEnable);
        }
    }
}

