/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.assistant.internal.core;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.core.service.IProvider;
import org.eclipse.gmf.runtime.common.core.service.IProviderChangeListener;
import org.eclipse.gmf.runtime.common.core.service.ProviderChangeEvent;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.ui.services.modelingassistant.IModelingAssistantOperation;
import org.eclipse.gmf.runtime.emf.ui.services.modelingassistant.IModelingAssistantProvider;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.assistant.internal.core.AssistantPlugin;
import org.eclipse.papyrus.infra.gmfdiag.assistant.internal.core.ModelingAssistantModelRegistry;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramUtils;
import org.eclipse.papyrus.infra.viewpoints.policy.PolicyChecker;

public class DelegatingModelingAssistantProvider
implements IModelingAssistantProvider,
IProviderChangeListener {
    private final CopyOnWriteArrayList<IProviderChangeListener> listeners = new CopyOnWriteArrayList();
    private final ThreadLocal<List<IModelingAssistantProvider>> currentProviders = new ThreadLocal<List<IModelingAssistantProvider>>(){

        @Override
        protected List<IModelingAssistantProvider> initialValue() {
            return Lists.newArrayList();
        }
    };

    public boolean provides(IOperation operation) {
        if (!(operation instanceof IModelingAssistantOperation) && ((IModelingAssistantOperation)operation).getContext() != null) {
            return false;
        }
        IModelingAssistantOperation op = (IModelingAssistantOperation)operation;
        IAdaptable adaptable = op.getContext();
        EditPart editPart = (EditPart)adaptable.getAdapter(EditPart.class);
        Diagram diag = DiagramUtils.getDiagramFrom((EditPart)editPart);
        if (diag != null && !DiagramUtils.isPapyrusGMFDiagram((Diagram)diag)) {
            return false;
        }
        List<IModelingAssistantProvider> current = this.currentProviders.get();
        current.clear();
        for (IModelingAssistantProvider next : ModelingAssistantModelRegistry.getInstance().getModelingAssistantProviders()) {
            if (!next.provides(operation)) continue;
            current.add(next);
        }
        return !current.isEmpty();
    }

    public void providerChanged(ProviderChangeEvent event) {
        if (!this.listeners.isEmpty()) {
            ProviderChangeEvent forward = new ProviderChangeEvent((IProvider)this);
            for (IProviderChangeListener next : this.listeners) {
                try {
                    next.providerChanged(forward);
                }
                catch (Exception e) {
                    AssistantPlugin.log.error("Uncaught exception in provider change listener", (Throwable)e);
                }
            }
        }
    }

    public void addProviderChangeListener(IProviderChangeListener listener) {
        this.listeners.addIfAbsent(listener);
    }

    public void removeProviderChangeListener(IProviderChangeListener listener) {
        this.listeners.remove(listener);
    }

    public List getTypes(String hint, IAdaptable data) {
        ArrayList result = Lists.newArrayList();
        for (IModelingAssistantProvider next : this.currentProviders.get()) {
            result.addAll(next.getTypes(hint, data));
        }
        this.currentProviders.get().clear();
        return this.filterViewpointExclusions(data, result);
    }

    public List getRelTypesOnSource(IAdaptable source) {
        ArrayList result = Lists.newArrayList();
        for (IModelingAssistantProvider next : this.currentProviders.get()) {
            result.addAll(next.getRelTypesOnSource(source));
        }
        this.currentProviders.get().clear();
        return this.filterViewpointExclusions(source, result);
    }

    public List getRelTypesOnTarget(IAdaptable target) {
        ArrayList result = Lists.newArrayList();
        for (IModelingAssistantProvider next : this.currentProviders.get()) {
            result.addAll(next.getRelTypesOnTarget(target));
        }
        this.currentProviders.get().clear();
        return this.filterViewpointExclusions(target, result);
    }

    public List getRelTypesOnSourceAndTarget(IAdaptable source, IAdaptable target) {
        ArrayList result = Lists.newArrayList();
        for (IModelingAssistantProvider next : this.currentProviders.get()) {
            result.addAll(next.getRelTypesOnSourceAndTarget(source, target));
        }
        this.currentProviders.get().clear();
        return this.filterViewpointExclusions(source, result);
    }

    public List getRelTypesForSREOnSource(IAdaptable source) {
        ArrayList result = Lists.newArrayList();
        for (IModelingAssistantProvider next : this.currentProviders.get()) {
            result.addAll(next.getRelTypesForSREOnSource(source));
        }
        return this.filterViewpointExclusions(source, result);
    }

    public List getRelTypesForSREOnTarget(IAdaptable target) {
        ArrayList result = Lists.newArrayList();
        for (IModelingAssistantProvider next : this.currentProviders.get()) {
            result.addAll(next.getRelTypesForSREOnTarget(target));
        }
        this.currentProviders.get().clear();
        return this.filterViewpointExclusions(target, result);
    }

    public List getTypesForSource(IAdaptable target, IElementType relationshipType) {
        ArrayList result = Lists.newArrayList();
        for (IModelingAssistantProvider next : this.currentProviders.get()) {
            result.addAll(next.getTypesForSource(target, relationshipType));
        }
        this.currentProviders.get().clear();
        return this.filterViewpointExclusions(target, result);
    }

    public List getTypesForTarget(IAdaptable source, IElementType relationshipType) {
        ArrayList result = Lists.newArrayList();
        for (IModelingAssistantProvider next : this.currentProviders.get()) {
            result.addAll(next.getTypesForTarget(source, relationshipType));
        }
        this.currentProviders.get().clear();
        return this.filterViewpointExclusions(source, result);
    }

    public EObject selectExistingElementForSource(IAdaptable target, IElementType relationshipType) {
        EObject result = null;
        for (IModelingAssistantProvider next : this.currentProviders.get()) {
            result = next.selectExistingElementForSource(target, relationshipType);
            if (result != null) break;
        }
        this.currentProviders.get().clear();
        return result;
    }

    public EObject selectExistingElementForTarget(IAdaptable source, IElementType relationshipType) {
        EObject result = null;
        for (IModelingAssistantProvider next : this.currentProviders.get()) {
            result = next.selectExistingElementForTarget(source, relationshipType);
            if (result != null) break;
        }
        this.currentProviders.get().clear();
        return result;
    }

    public List getTypesForPopupBar(IAdaptable host) {
        ArrayList result = Lists.newArrayList();
        for (IModelingAssistantProvider next : this.currentProviders.get()) {
            result.addAll(next.getTypesForPopupBar(host));
        }
        this.currentProviders.get().clear();
        return this.filterViewpointExclusions(host, result);
    }

    protected List<? extends IElementType> filterViewpointExclusions(IAdaptable context, List<? extends IElementType> elementTypes) {
        Diagram diagram;
        View view = context == null ? null : (View)context.getAdapter(View.class);
        Diagram diagram2 = diagram = view == null ? null : DiagramUtils.getContainingDiagram((View)view);
        if (diagram != null) {
            Iterator<? extends IElementType> iter = elementTypes.iterator();
            while (iter.hasNext()) {
                if (PolicyChecker.getFor((EObject)diagram).isInModelingAssistants(diagram, iter.next())) continue;
                iter.remove();
            }
        }
        return elementTypes;
    }
}

