/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.properties;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.uml.domain.services.IEditableChecker;
import org.eclipse.papyrus.uml.domain.services.properties.ILogger;
import org.eclipse.uml2.uml.Artifact;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.StructuredClassifier;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;

public class PropertiesMemberEndServices {
    private static final String ASSOCIATION = "Association";
    private static final String CLASSIFIER = "Classifier";
    private static final String FEATURE_NOT_FOUND = "Cannot find a valid feature for type %s.";
    private static final String NULL_TYPE = "The type is null!";
    private static final String OWNER = "owner";
    private static final String UNKNOWN_TYPE = "Unknown type : %s";
    private static final String UNMODIFIED_FEATURE = "Cannot change End owner for n-ary associations";
    private final ILogger logger;
    private final IEditableChecker checker;

    public PropertiesMemberEndServices(ILogger logger, IEditableChecker checker) {
        this.logger = logger;
        this.checker = checker;
    }

    public void setNavigable(Property memberEnd, boolean isNavigable) {
        if (memberEnd.isNavigable() != isNavigable) {
            Association association = memberEnd.getAssociation();
            EList navigableOwnedEnds = association.getNavigableOwnedEnds();
            if (isNavigable) {
                navigableOwnedEnds.add((Object)memberEnd);
            } else {
                if (memberEnd.getOwningAssociation() == null && memberEnd.getOwner() instanceof Classifier) {
                    association.getOwnedEnds().add((Object)memberEnd);
                }
                if (navigableOwnedEnds.contains((Object)memberEnd)) {
                    navigableOwnedEnds.remove((Object)memberEnd);
                }
            }
        }
    }

    public String getOwner(Property memberEnd) {
        if (memberEnd.getAssociation().getOwnedEnds().contains((Object)memberEnd)) {
            return ASSOCIATION;
        }
        return CLASSIFIER;
    }

    public List<String> getOwnerEnumerations(Element obj) {
        return Arrays.asList(ASSOCIATION, CLASSIFIER);
    }

    public void setOwner(Property memberEnd, String owner) {
        boolean isOwnedByAssociation = ASSOCIATION.equals(owner);
        Association association = memberEnd.getAssociation();
        if (association.getMemberEnds().size() > 2) {
            this.logger.log(UNMODIFIED_FEATURE, ILogger.ILogLevel.WARNING);
        } else if (isOwnedByAssociation) {
            association.getOwnedEnds().add((Object)memberEnd);
        } else {
            EList ownerList = association.getEndTypes();
            Type ownerType = ((Type)ownerList.get(0)).equals(memberEnd.getType()) && ownerList.size() > 1 ? (Type)ownerList.get(1) : (Type)ownerList.get(0);
            EStructuralFeature ownedAttributeFeature = this.getOwnedAttributeFeatureForType(ownerType);
            if (ownedAttributeFeature != null) {
                ((EList)ownerType.eGet(ownedAttributeFeature)).add((Object)memberEnd);
            }
        }
    }

    public EStructuralFeature getOwnedAttributeFeatureForType(Type type) {
        EReference ownedAttributeFeature = null;
        if (type == null) {
            this.logger.log(NULL_TYPE, ILogger.ILogLevel.WARNING);
        } else if (type instanceof StructuredClassifier) {
            ownedAttributeFeature = UMLPackage.eINSTANCE.getStructuredClassifier_OwnedAttribute();
        } else if (type instanceof Interface) {
            ownedAttributeFeature = UMLPackage.eINSTANCE.getInterface_OwnedAttribute();
        } else if (type instanceof DataType) {
            ownedAttributeFeature = UMLPackage.eINSTANCE.getDataType_OwnedAttribute();
        } else if (type instanceof Artifact) {
            ownedAttributeFeature = UMLPackage.eINSTANCE.getArtifact_OwnedAttribute();
        } else if (type instanceof Signal) {
            ownedAttributeFeature = UMLPackage.eINSTANCE.getSignal_OwnedAttribute();
        } else {
            String eClassName = type.eClass().getName();
            this.logger.log(String.format(UNKNOWN_TYPE, eClassName), ILogger.ILogLevel.WARNING);
            ownedAttributeFeature = type.eClass().getEStructuralFeature("ownedAttribute");
            if (ownedAttributeFeature == null) {
                this.logger.log(String.format(FEATURE_NOT_FOUND, eClassName), ILogger.ILogLevel.WARNING);
            }
        }
        return ownedAttributeFeature;
    }

    public boolean isMemberEndPropertyEditable(Element source, String propertyPath) {
        boolean isEditable = true;
        if (propertyPath.equals(OWNER)) {
            EList memberEnds = ((Property)source).getAssociation().getMemberEnds();
            if (memberEnds.size() == 2) {
                Property otherMemberEnd;
                if (this.isAssociation((Property)memberEnds.get(0)) && this.isAssociation((Property)memberEnds.get(1))) {
                    isEditable = false;
                }
                if ((otherMemberEnd = (Property)memberEnds.stream().filter(memberEnd -> memberEnd != source).collect(Collectors.toList()).get(0)).getType() != null && otherMemberEnd.getType().eClass() == UMLPackage.eINSTANCE.getUseCase()) {
                    isEditable = false;
                }
            } else {
                isEditable = ((Property)source).getAssociation().getMemberEnds().size() <= 2 && this.checker.canEdit((EObject)source);
            }
        } else {
            isEditable = this.checker.canEdit((EObject)source);
        }
        return isEditable;
    }

    private boolean isAssociation(Property property) {
        if (property.getType() == null) {
            return false;
        }
        return property.getType().eClass() == UMLPackage.eINSTANCE.getAssociation();
    }
}

