/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.drop.diagrams;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.uml.domain.services.drop.IExternalSourceToRepresentationDropChecker;
import org.eclipse.papyrus.uml.domain.services.status.CheckStatus;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Component;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Reception;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class ComponentExternalSourceToRepresentationDropChecker
implements IExternalSourceToRepresentationDropChecker {
    @Override
    public CheckStatus canDragAndDrop(EObject elementToDrop, EObject newSemanticContainer) {
        return (CheckStatus)new ComponentDropInsideRepresentationCheckerSwitch(newSemanticContainer).doSwitch(elementToDrop);
    }

    static class ComponentDropInsideRepresentationCheckerSwitch
    extends UMLSwitch<CheckStatus> {
        private final EObject newSemanticContainer;

        ComponentDropInsideRepresentationCheckerSwitch(EObject target) {
            this.newSemanticContainer = target;
        }

        public CheckStatus caseComment(Comment comment) {
            CheckStatus result = this.newSemanticContainer instanceof Package ? CheckStatus.YES : CheckStatus.no("Comment can only be drag and drop on a Package");
            return result;
        }

        public CheckStatus caseComponent(Component component) {
            CheckStatus result = this.newSemanticContainer instanceof Component || this.newSemanticContainer instanceof Package || this.newSemanticContainer instanceof Property ? CheckStatus.YES : CheckStatus.no("Component can only be drag and drop on a Component, Package, or Property");
            return result;
        }

        public CheckStatus caseConstraint(Constraint constraint) {
            CheckStatus result = this.newSemanticContainer instanceof Package ? CheckStatus.YES : CheckStatus.no("Constraint can only be drag and drop on a Package");
            return result;
        }

        public CheckStatus caseInterface(Interface interfaceElement) {
            CheckStatus result = this.newSemanticContainer instanceof Package || this.newSemanticContainer instanceof Property ? CheckStatus.YES : CheckStatus.no("Interface can only be drag and drop on a Package or Property");
            return result;
        }

        public CheckStatus caseOperation(Operation operation) {
            CheckStatus result = this.newSemanticContainer instanceof Interface ? CheckStatus.YES : CheckStatus.no("Operation can only be drag and drop on an Interface");
            return result;
        }

        public CheckStatus casePackage(Package pack) {
            CheckStatus result = this.newSemanticContainer instanceof Package ? CheckStatus.YES : CheckStatus.no("Package can only be drag and drop on a Package");
            return result;
        }

        public CheckStatus casePort(Port port) {
            CheckStatus result = this.newSemanticContainer instanceof Component || this.newSemanticContainer instanceof Property ? CheckStatus.YES : CheckStatus.no("Port can only be drag and drop on Component or Property");
            return result;
        }

        public CheckStatus caseProperty(Property property) {
            Type type;
            CheckStatus result = CheckStatus.no("Property can only be drag and drop on a Component, Interface, or typed Property");
            if (this.newSemanticContainer instanceof Classifier && ((Classifier)this.newSemanticContainer).getAllAttributes().contains((Object)property)) {
                result = CheckStatus.YES;
            } else if (this.newSemanticContainer instanceof Property && (type = ((Property)this.newSemanticContainer).getType()) instanceof Classifier && ((Classifier)type).getAllAttributes().contains((Object)property)) {
                result = CheckStatus.YES;
            }
            return result;
        }

        public CheckStatus caseReception(Reception reception) {
            CheckStatus result = this.newSemanticContainer instanceof Interface ? CheckStatus.YES : CheckStatus.no("Reception can ony be drag and drop on an Interface");
            return result;
        }

        public CheckStatus caseType(Type type) {
            CheckStatus result = this.newSemanticContainer instanceof Property ? CheckStatus.YES : CheckStatus.no("Type can only be drag and drop on a Property");
            return result;
        }

        public CheckStatus defaultCase(EObject object) {
            return CheckStatus.no("DnD is not authorized.");
        }
    }
}

