/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.directedit;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.uml.domain.services.directedit.IDirectEditValueConsumer;
import org.eclipse.papyrus.uml.domain.services.status.CheckStatus;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class ElementDirectEditValueConsumer
implements IDirectEditValueConsumer {
    @Override
    public CheckStatus consumeNewLabel(EObject owner, String editedText) {
        if (owner != null) {
            return (CheckStatus)new ElementDirectEditValueConsumerSwitch(editedText).doSwitch(owner);
        }
        return CheckStatus.no("Can't execute a Direct Edit tool on null");
    }

    public static class ElementDirectEditValueConsumerSwitch
    extends UMLSwitch<CheckStatus> {
        private final String editedText;

        public ElementDirectEditValueConsumerSwitch(String editedText) {
            this.editedText = editedText;
        }

        public CheckStatus caseComment(Comment comment) {
            comment.setBody(this.editedText);
            return CheckStatus.YES;
        }

        public CheckStatus caseNamedElement(NamedElement nameElement) {
            nameElement.setName(this.editedText);
            return CheckStatus.YES;
        }

        public CheckStatus defaultCase(EObject object) {
            return CheckStatus.no("[Direct Edit] Unhandled element : " + object.eClass().getName());
        }
    }
}

