/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.create;

import java.text.MessageFormat;
import java.util.List;
import java.util.Optional;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.uml.domain.services.UMLHelper;
import org.eclipse.papyrus.uml.domain.services.create.ICreatorChecker;
import org.eclipse.papyrus.uml.domain.services.status.CheckStatus;
import org.eclipse.uml2.uml.FinalState;

public class ElementCreationChecker
implements ICreatorChecker {
    @Override
    public CheckStatus canCreate(EObject parent, String type, String containmentReferenceName) {
        String prefix;
        CheckStatus result = CheckStatus.YES;
        Object message = null;
        if (parent == null) {
            message = "A parent container should be specified.";
        }
        if (type == null || type.isBlank()) {
            prefix = Optional.ofNullable(message).map(msg -> msg + " ").orElse("");
            message = prefix + "A type should be specified.";
        }
        if (containmentReferenceName == null || containmentReferenceName.isBlank()) {
            prefix = Optional.ofNullable(message).map(msg -> msg + " ").orElse("");
            message = prefix + "A reference should be specified.";
        }
        if (message == null) {
            EClass eClass;
            result = this.genericChecking(parent, containmentReferenceName);
            if (result.isValid() && (eClass = UMLHelper.toEClass(type)) != null) {
                switch (eClass.getClassifierID()) {
                    case 56: {
                        result = this.handleRegion(parent);
                        break;
                    }
                    default: {
                        result = CheckStatus.YES;
                        break;
                    }
                }
            }
        } else {
            result = CheckStatus.no((String)message);
        }
        return result;
    }

    private CheckStatus genericChecking(EObject parent, String containmentReferenceName) {
        CheckStatus result = CheckStatus.YES;
        EStructuralFeature feature = parent.eClass().getEStructuralFeature(containmentReferenceName);
        if (feature != null) {
            Object featureContent = parent.eGet(feature);
            result = feature.isMany() ? (feature.getUpperBound() == -1 ? CheckStatus.YES : (((List)featureContent).size() < feature.getUpperBound() ? CheckStatus.YES : CheckStatus.no(MessageFormat.format("{0} feature has already {1} elements.", containmentReferenceName, feature.getUpperBound())))) : (parent.eIsSet(feature) ? CheckStatus.no(MessageFormat.format("{0} feature is already set.", containmentReferenceName)) : CheckStatus.YES);
        } else {
            result = CheckStatus.no(MessageFormat.format("{0} feature has not been found for the EClass {1}.", containmentReferenceName, parent.eClass().getName()));
        }
        return result;
    }

    private CheckStatus handleRegion(EObject parent) {
        CheckStatus result = CheckStatus.YES;
        if (parent instanceof FinalState) {
            result = CheckStatus.no("A Final State can not have a region.");
        }
        return result;
    }
}

