/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services;

import java.util.function.BiFunction;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.uml2.uml.Component;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.UMLPackage;

public final class UMLHelper {
    private static final String UML_PACKAGE_PREFIX = "uml::";

    private UMLHelper() {
    }

    public static EClass toEClass(String type) {
        if (type != null && type.startsWith(UML_PACKAGE_PREFIX)) {
            return UMLHelper.toEClass(type.replace(UML_PACKAGE_PREFIX, ""));
        }
        EClassifier classifier = UMLPackage.eINSTANCE.getEClassifier(type);
        EClass eClass = classifier instanceof EClass ? (EClass)classifier : null;
        return eClass;
    }

    public static Namespace getPackagedContainer(Element element) {
        Package result = null;
        if (element instanceof Package) {
            Package pkg;
            result = pkg = (Package)element;
        } else if (element instanceof Component) {
            Component cmp = (Component)element;
            result = cmp;
        } else if (element != null) {
            result = UMLHelper.getPackagedContainer(element.getOwner());
        }
        return result;
    }

    public static EList<PackageableElement> getPackagedContainment(Element element) {
        Namespace container = UMLHelper.getPackagedContainer(element);
        EList result = null;
        if (container instanceof Package) {
            Package pkg = (Package)container;
            result = pkg.getPackagedElements();
        } else if (container instanceof Component) {
            Component cmp = (Component)container;
            result = cmp.getPackagedElements();
        }
        return result;
    }

    public static BiFunction<String, EClass, PackageableElement> getPackagedCreator(Element element) {
        Namespace container = UMLHelper.getPackagedContainer(element);
        BiFunction<String, EClass, PackageableElement> result = null;
        if (container instanceof Package) {
            Package pkg = (Package)container;
            result = (name, type) -> pkg.createPackagedElement(name, type);
        } else if (container instanceof Component) {
            Component cmp = (Component)container;
            result = (name, type) -> cmp.createPackagedElement(name, type);
        }
        return result;
    }
}

