/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.java.reverse.umlparser;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.resource.UMLResource;

public class ModelManager {
    private Resource model;
    private ResourceSet resourceSet;

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public Resource getModel() {
        return this.model;
    }

    protected void createModel(String filename) {
        this.resourceSet = new ResourceSetImpl();
        this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("uml", UMLResource.Factory.INSTANCE);
        this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", UMLResource.Factory.INSTANCE);
        URI fileURI = URI.createFileURI((String)new File(filename).getAbsolutePath());
        System.out.println("URI= " + String.valueOf(fileURI));
        this.model = this.resourceSet.createResource(fileURI);
    }

    protected void loadModel(String filename) {
        UMLFactory.eINSTANCE.createActor();
        this.resourceSet = new ResourceSetImpl();
        this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("uml", UMLResource.Factory.INSTANCE);
        this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", UMLResource.Factory.INSTANCE);
        URI fileURI = URI.createFileURI((String)new File(filename).getAbsolutePath());
        System.out.println("URI= " + String.valueOf(fileURI));
        this.model = this.resourceSet.getResource(fileURI, true);
    }

    public void save() {
        try {
            System.out.println("Save model.");
            this.model.save(Collections.EMPTY_MAP);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

