/**
 * Copyright (c) 2014 CEA LIST.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     CEA LIST - initial API and implementation
 */
package org.eclipse.papyrus.designer.languages.java.codegen.xtend;

import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.languages.common.base.GenUtils;
import org.eclipse.papyrus.designer.languages.common.profile.Codegen.AOverride;
import org.eclipse.papyrus.designer.languages.java.codegen.Constants;
import org.eclipse.papyrus.designer.languages.java.codegen.utils.Modifier;
import org.eclipse.papyrus.designer.languages.java.profile.PapyrusJava.Default;
import org.eclipse.papyrus.designer.languages.java.profile.PapyrusJava.Native;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.profile.standard.Create;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class JavaOperations {
  public static CharSequence javaOperationImplementation(final Operation operation) {
    StringConcatenation _builder = new StringConcatenation();
    String _body = GenUtils.getBody(operation, Constants.supportedLanguages);
    _builder.append(_body);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public static String javaReturnSpec(final Operation operation) {
    String _xifexpression = null;
    if (((operation.getType() == null) || JavaOperations.isConstructor(operation))) {
      _xifexpression = JavaOperations.constructorOrVoid(operation);
    } else {
      String _javaTypeOrVoid = JavaOperations.javaTypeOrVoid(IterableExtensions.<Parameter>head(operation.returnResult()));
      _xifexpression = (_javaTypeOrVoid + " ");
    }
    return _xifexpression;
  }

  public static String javaTypeOrVoid(final Parameter parameter) {
    if ((parameter != null)) {
      return JavaTypedElement.javaType(parameter);
    } else {
      return "void";
    }
  }

  public static CharSequence throwss(final Operation operation) {
    StringConcatenation _builder = new StringConcatenation();
    {
      int _length = ((Object[])Conversions.unwrapArray(operation.getRaisedExceptions(), Object.class)).length;
      boolean _greaterThan = (_length > 0);
      if (_greaterThan) {
        _builder.append("throws ");
        {
          EList<Type> _raisedExceptions = operation.getRaisedExceptions();
          boolean _hasElements = false;
          for(final Type re : _raisedExceptions) {
            if (!_hasElements) {
              _hasElements = true;
            } else {
              _builder.appendImmediate(",", "");
            }
            String _name = re.getName();
            _builder.append(_name);
          }
        }
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }

  public static String constructorOrVoid(final Operation operation) {
    String _xifexpression = null;
    boolean _isConstructor = JavaOperations.isConstructor(operation);
    if (_isConstructor) {
      _xifexpression = "";
    } else {
      _xifexpression = "void ";
    }
    return _xifexpression;
  }

  public static boolean isConstructor(final Operation operation) {
    return GenUtils.hasStereotype(operation, Create.class);
  }

  public static Collection<Operation> getOwnedOperations(final Classifier cl) {
    Collection<Operation> _xblockexpression = null;
    {
      final EList<Operation> operations = JavaOperations.getOwnedOperationsWNull(cl);
      Collection<Operation> _xifexpression = null;
      if ((operations == null)) {
        _xifexpression = CollectionLiterals.<Operation>emptySet();
      } else {
        _xifexpression = operations;
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }

  public static EList<Operation> getOwnedOperationsWNull(final Classifier cl) {
    EList<Operation> _xifexpression = null;
    if ((cl instanceof org.eclipse.uml2.uml.Class)) {
      _xifexpression = ((org.eclipse.uml2.uml.Class) cl).getOwnedOperations();
    } else {
      EList<Operation> _xifexpression_1 = null;
      if ((cl instanceof DataType)) {
        _xifexpression_1 = ((DataType) cl).getOwnedOperations();
      } else {
        EList<Operation> _xifexpression_2 = null;
        if ((cl instanceof Interface)) {
          _xifexpression_2 = ((Interface) cl).getOwnedOperations();
        } else {
          _xifexpression_2 = null;
        }
        _xifexpression_1 = _xifexpression_2;
      }
      _xifexpression = _xifexpression_1;
    }
    return _xifexpression;
  }

  public static CharSequence javaOperationDeclaration(final Operation operation) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _javaOperationDoc = JavaDocumentation.javaOperationDoc(operation);
    _builder.append(_javaOperationDoc);
    _builder.newLineIfNotEmpty();
    {
      boolean _hasStereotype = GenUtils.hasStereotype(operation, AOverride.class);
      if (_hasStereotype) {
        _builder.append("@Override");
        _builder.newLine();
      }
    }
    String _methodModifiers = Modifier.methodModifiers(operation);
    _builder.append(_methodModifiers);
    String _javaReturnSpec = JavaOperations.javaReturnSpec(operation);
    _builder.append(_javaReturnSpec);
    String _name = operation.getName();
    _builder.append(_name);
    _builder.append("(");
    CharSequence _javaOperationParameters = JavaParameter.javaOperationParameters(operation);
    _builder.append(_javaOperationParameters);
    _builder.append(") ");
    CharSequence _throwss = JavaOperations.throwss(operation);
    _builder.append(_throwss);
    {
      boolean _mustGenerateBody = JavaOperations.mustGenerateBody(operation);
      if (_mustGenerateBody) {
        _builder.append("{");
      } else {
        _builder.append(";");
      }
    }
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    {
      boolean _mustGenerateBody_1 = JavaOperations.mustGenerateBody(operation);
      if (_mustGenerateBody_1) {
        CharSequence _javaOperationImplementation = JavaOperations.javaOperationImplementation(operation);
        _builder.append(_javaOperationImplementation, "\t");
      }
    }
    _builder.newLineIfNotEmpty();
    {
      boolean _mustGenerateBody_2 = JavaOperations.mustGenerateBody(operation);
      if (_mustGenerateBody_2) {
        _builder.append("}");
      }
    }
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public static boolean isAbstract(final Operation operation) {
    return (((operation.isAbstract() && (operation.getOwner() instanceof Classifier)) && (((Classifier) operation.getOwner()).isAbstract() || (operation.getOwner() instanceof Enumeration))) || 
      (operation.getInterface() != null));
  }

  public static boolean isDefault(final Operation operation) {
    return ((operation.getInterface() != null) && (UMLUtil.<Default>getStereotypeApplication(operation, Default.class) != null));
  }

  public static boolean mustGenerateBody(final Operation operation) {
    boolean _isAbstract = JavaOperations.isAbstract(operation);
    boolean _not = (!_isAbstract);
    if (_not) {
      Native _stereotypeApplication = UMLUtil.<Native>getStereotypeApplication(operation, Native.class);
      return (_stereotypeApplication == null);
    } else {
      Interface _interface = operation.getInterface();
      boolean _tripleEquals = (_interface == null);
      if (_tripleEquals) {
        boolean _isStatic = operation.isStatic();
        if (_isStatic) {
          Native _stereotypeApplication_1 = UMLUtil.<Native>getStereotypeApplication(operation, Native.class);
          return (_stereotypeApplication_1 == null);
        } else {
          return false;
        }
      } else {
        Interface _interface_1 = operation.getInterface();
        boolean _tripleNotEquals = (_interface_1 != null);
        if (_tripleNotEquals) {
          return (operation.isStatic() || (UMLUtil.<Default>getStereotypeApplication(operation, Default.class) != null));
        }
      }
    }
    return true;
  }
}
