/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.cpp.reverse;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IField;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Const;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Mutable;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Typedef;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Volatile;
import org.eclipse.papyrus.designer.languages.cpp.reverse.ASTUtils;
import org.eclipse.papyrus.designer.languages.cpp.reverse.CommentUtils;
import org.eclipse.papyrus.designer.languages.cpp.reverse.PkgDependencies;
import org.eclipse.papyrus.designer.languages.cpp.reverse.ReverseUtils;
import org.eclipse.papyrus.designer.languages.cpp.reverse.utils.TypeOperationsEnhanced;
import org.eclipse.papyrus.designer.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.TypedElement;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class PropertyUtils {
    public static void createProperty(IField field, Classifier classifier) {
        Property _createProperty = UMLFactory.eINSTANCE.createProperty();
        Procedures.Procedure1 _function = it -> it.setName(field.getElementName());
        Property prop = (Property)ObjectExtensions.operator_doubleArrow((Object)_createProperty, (Procedures.Procedure1)_function);
        if (classifier instanceof DataType) {
            EList _ownedAttributes = ((DataType)classifier).getOwnedAttributes();
            _ownedAttributes.add((Object)prop);
        } else if (classifier instanceof Class) {
            EList _ownedAttributes_1 = ((Class)classifier).getOwnedAttributes();
            _ownedAttributes_1.add((Object)prop);
        }
        ReverseUtils.setXmlID((NamedElement)prop);
        PropertyUtils.updateProperty(field, prop);
    }

    public static void updateProperty(IField field, Property prop) {
        try {
            boolean _isSimpleAssociation;
            ReverseUtils.unapplyAllStereotypes((Element)prop);
            Type type = null;
            boolean doNotAnalyzeDeclaration = false;
            try {
                IASTNode fieldNode = ASTUtils.findEnclosingNode((ISourceReference)field);
                if (fieldNode != null) {
                    String rawSignature = fieldNode.getRawSignature().replaceAll("\\n", "").replaceAll("\\r", "").replaceAll(";", "").replaceAll("\\s+", " ").trim();
                    Pattern pattern = Pattern.compile("(\\()(\\s*)(\\*)(.*)(\\))(\\s*)(\\()(.*)(\\))");
                    Matcher matcher = pattern.matcher(rawSignature);
                    boolean _find = matcher.find();
                    if (_find) {
                        String typeName = rawSignature.replaceFirst(Pattern.quote(field.getElementName()), "typeName").replaceFirst("typedef", "");
                        Package packageable = null;
                        Element _owner = prop.getOwner();
                        if (_owner instanceof Class) {
                            Element _owner_1 = prop.getOwner();
                            packageable = (Class)_owner_1;
                        } else {
                            packageable = prop.getNearestPackage();
                        }
                        String ownerName = packageable.getName();
                        PrimitiveType _createPrimitiveType = UMLFactory.eINSTANCE.createPrimitiveType();
                        Procedures.Procedure1 _function = it -> {
                            String _elementName = field.getElementName();
                            String _plus = ownerName + "_" + _elementName;
                            String _plus_1 = _plus + "_funcptr";
                            it.setName(_plus_1);
                        };
                        PrimitiveType primitiveType = (PrimitiveType)ObjectExtensions.operator_doubleArrow((Object)_createPrimitiveType, (Procedures.Procedure1)_function);
                        if (packageable instanceof Package) {
                            EList _ownedTypes = packageable.getOwnedTypes();
                            _ownedTypes.add((Object)primitiveType);
                        } else {
                            EList _nestedClassifiers = ((Class)packageable).getNestedClassifiers();
                            _nestedClassifiers.add((Object)primitiveType);
                        }
                        StereotypeUtil.apply((Element)primitiveType, Typedef.class);
                        Typedef _stereotypeApplication = (Typedef)UMLUtil.getStereotypeApplication((Element)primitiveType, Typedef.class);
                        _stereotypeApplication.setDefinition(typeName);
                        type = primitiveType;
                        doNotAnalyzeDeclaration = true;
                    }
                }
                if (type == null && (field.getTypeName().equals("enum") || field.getTypeName().equals("struct") || field.getTypeName().equals("class"))) {
                    String rawSignature_1 = fieldNode.getRawSignature();
                    String trimmedRawSignature = rawSignature_1.replaceAll("\\n", "").replaceAll("\\r", "").replaceAll(";", "").replaceAll("\\s+", " ").trim();
                    Pattern pattern_1 = Pattern.compile("(\\{)(.*)(\\})");
                    Matcher matcher_1 = pattern_1.matcher(trimmedRawSignature);
                    boolean _find_1 = matcher_1.find();
                    if (_find_1) {
                        boolean _greaterThan;
                        String[] tokens = rawSignature_1.split("}");
                        String[] _converted_tokens = tokens;
                        int _size = ((List)Conversions.doWrapArray((Object)_converted_tokens)).size();
                        boolean bl = _greaterThan = _size > 0;
                        if (_greaterThan) {
                            String[] _converted_tokens_1 = tokens;
                            int _size_1 = ((List)Conversions.doWrapArray((Object)_converted_tokens_1)).size();
                            int _minus = _size_1 - 1;
                            String lastToken = tokens[_minus];
                            boolean _contains = lastToken.contains(field.getElementName());
                            if (_contains) {
                                lastToken = lastToken.replaceFirst(Pattern.quote(field.getElementName()), "typeName");
                            }
                            Object typeName_1 = "";
                            String[] _converted_tokens_2 = tokens;
                            int _size_2 = ((List)Conversions.doWrapArray((Object)_converted_tokens_2)).size();
                            int _minus_1 = _size_2 - 1;
                            ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _minus_1, true);
                            for (Integer i : _doubleDotLessThan) {
                                String _typeName = typeName_1;
                                String _get = tokens[i];
                                typeName_1 = _typeName + _get;
                            }
                            String _typeName_1 = typeName_1;
                            typeName_1 = _typeName_1 + lastToken;
                            Package packageable_1 = null;
                            Element _owner_2 = prop.getOwner();
                            if (_owner_2 instanceof Class) {
                                Element _owner_3 = prop.getOwner();
                                packageable_1 = (Class)_owner_3;
                            } else {
                                packageable_1 = prop.getNearestPackage();
                            }
                            String ownerName_1 = packageable_1.getName();
                            PrimitiveType _createPrimitiveType_1 = UMLFactory.eINSTANCE.createPrimitiveType();
                            Procedures.Procedure1 _function_1 = it -> {
                                try {
                                    String _elementName = field.getElementName();
                                    String _plus = ownerName_1 + "_" + _elementName;
                                    String _plus_1 = _plus + "_anon_";
                                    String _typeName_2 = field.getTypeName();
                                    String _plus_2 = _plus_1 + _typeName_2;
                                    it.setName(_plus_2);
                                }
                                catch (Throwable _e) {
                                    throw Exceptions.sneakyThrow((Throwable)_e);
                                }
                            };
                            PrimitiveType primitiveType_1 = (PrimitiveType)ObjectExtensions.operator_doubleArrow((Object)_createPrimitiveType_1, (Procedures.Procedure1)_function_1);
                            if (packageable_1 instanceof Package) {
                                EList _ownedTypes_1 = packageable_1.getOwnedTypes();
                                _ownedTypes_1.add((Object)primitiveType_1);
                            } else {
                                EList _nestedClassifiers_1 = ((Class)packageable_1).getNestedClassifiers();
                                _nestedClassifiers_1.add((Object)primitiveType_1);
                            }
                            StereotypeUtil.apply((Element)primitiveType_1, Typedef.class);
                            Typedef _stereotypeApplication_1 = (Typedef)UMLUtil.getStereotypeApplication((Element)primitiveType_1, Typedef.class);
                            _stereotypeApplication_1.setDefinition((String)typeName_1);
                            type = primitiveType_1;
                            doNotAnalyzeDeclaration = true;
                        }
                    }
                }
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) {
                    Exception e = (Exception)_t;
                    e.printStackTrace();
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            if (type == null) {
                type = ReverseUtils.getUMLType(ASTUtils.getQualifiedName((ISourceReference)field), (ICElement)field);
            }
            prop.setType(type);
            prop.setName(field.getElementName());
            if (!doNotAnalyzeDeclaration) {
                Element _owner;
                IASTNode node = ASTUtils.getSelector(field.getTranslationUnit()).findEnclosingNode(field.getSourceRange().getStartPos(), field.getSourceRange().getLength());
                if (node instanceof IASTSimpleDeclaration) {
                    ReverseUtils.analyzeDeclaration((List)Conversions.doWrapArray((Object)((IASTSimpleDeclaration)node).getDeclarators()), prop.getType(), (TypedElement)prop, "C++");
                }
                if ((_owner = prop.getOwner()) instanceof NamedElement) {
                    Element _owner_1 = prop.getOwner();
                    PkgDependencies.createDependency((NamedElement)_owner_1, (NamedElement)type);
                }
                CommentUtils.addComment((Element)prop, node);
            }
            prop.setIsStatic(field.isStatic());
            prop.setVisibility(ASTUtils.convertVisibility(field.getVisibility()));
            ReverseUtils.applyStereotype((Element)prop, field.isConst(), Const.class);
            ReverseUtils.applyStereotype((Element)prop, field.isVolatile(), Volatile.class);
            ReverseUtils.applyStereotype((Element)prop, field.isMutable(), Mutable.class);
            boolean createAssociations = false;
            if (createAssociations) {
                EObject _eContainer = prop.eContainer();
                Association asso = TypeOperationsEnhanced.createAssociationFromProperty(prop, true, AggregationKind.NONE_LITERAL, false, AggregationKind.NONE_LITERAL, StringExtensions.toFirstLower((String)((Classifier)_eContainer).getName()), 1, 1);
                String _name = prop.getName();
                String _plus = "A_" + _name;
                String _plus_1 = _plus + "_";
                EObject _eContainer_1 = prop.eContainer();
                String _firstLower = StringExtensions.toFirstLower((String)((Classifier)_eContainer_1).getName());
                String _plus_2 = _plus_1 + _firstLower;
                asso.setName(_plus_2);
            }
            if (_isSimpleAssociation = ReverseUtils.isSimpleAssociation(prop)) {
                prop.setAggregation(AggregationKind.NONE_LITERAL);
            } else {
                boolean _isAggregation = ReverseUtils.isAggregation(prop);
                if (_isAggregation) {
                    prop.setAggregation(AggregationKind.SHARED_LITERAL);
                } else {
                    boolean _isComposition = ReverseUtils.isComposition(prop);
                    if (_isComposition) {
                        prop.setAggregation(AggregationKind.COMPOSITE_LITERAL);
                    }
                }
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

