/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.cpp.codegen.utils;

import org.eclipse.papyrus.designer.infra.base.StringUtils;
import org.eclipse.papyrus.designer.languages.common.base.GenUtils;
import org.eclipse.papyrus.designer.languages.common.profile.Codegen.AOverride;
import org.eclipse.papyrus.designer.languages.common.profile.Codegen.ListHint;
import org.eclipse.papyrus.designer.languages.cpp.codegen.preferences.CppCodeGenUtils;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Array;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Const;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Constexpr;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Mutable;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Ptr;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Ref;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.StorageClass;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Volatile;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.util.UMLUtil;

public class Modifier {
    protected static final String EMPTY = "";
    protected static final String PTR = "*";
    protected static final String EMPTY_ARRAY = "[]";

    public static String modPtr(Element propertyOrParameter) {
        ParameterDirectionKind directionKind;
        boolean ptrOrRef;
        Ptr cppPtr = (Ptr)UMLUtil.getStereotypeApplication((Element)propertyOrParameter, Ptr.class);
        Object ptr = cppPtr != null ? (cppPtr.getDeclaration() != null && !cppPtr.getDeclaration().equals(EMPTY) ? cppPtr.getDeclaration() : PTR) : (propertyOrParameter instanceof Property && ((Property)propertyOrParameter).getAggregation() == AggregationKind.SHARED_LITERAL ? PTR : EMPTY);
        boolean bl = ptrOrRef = GenUtils.hasStereotype((Element)propertyOrParameter, Ref.class) || GenUtils.hasStereotype((Element)propertyOrParameter, Ptr.class);
        if (propertyOrParameter instanceof Parameter && ((directionKind = ((Parameter)propertyOrParameter).getDirection()) == ParameterDirectionKind.OUT_LITERAL || directionKind == ParameterDirectionKind.INOUT_LITERAL) && !ptrOrRef) {
            ptr = (String)ptr + CppCodeGenUtils.getOutInoutOp();
        }
        return ptr;
    }

    public static String modRef(Element propertyOrParameter) {
        Ref cppRef = (Ref)UMLUtil.getStereotypeApplication((Element)propertyOrParameter, Ref.class);
        String ref = cppRef != null ? (cppRef.getDeclaration() != null && !cppRef.getDeclaration().equals(EMPTY) ? cppRef.getDeclaration() : "&") : EMPTY;
        return ref;
    }

    public static String modArray(MultiplicityElement propertyOrParameter) {
        Array cppArray = (Array)UMLUtil.getStereotypeApplication((Element)propertyOrParameter, Array.class);
        String array = EMPTY;
        if (cppArray != null) {
            array = cppArray.getDefinition() != null && !cppArray.getDefinition().isEmpty() ? cppArray.getDefinition() : EMPTY_ARRAY;
        } else {
            ListHint listHint = (ListHint)GenUtils.getApplicationTree((Element)propertyOrParameter, ListHint.class);
            int lower = propertyOrParameter.getLower();
            int upper = propertyOrParameter.getUpper();
            if (upper == -1) {
                if (listHint == null || listHint.getVariable() == null) {
                    array = Modifier.isReturn((Element)propertyOrParameter) ? PTR : EMPTY_ARRAY;
                }
            } else if (upper > 1) {
                if (Modifier.isReturn((Element)propertyOrParameter)) {
                    array = PTR;
                } else if (upper == lower) {
                    if (listHint == null || listHint.getFixed() == null) {
                        array = String.format("[%d]", upper);
                    }
                } else if (listHint == null || listHint.getBounded() == null) {
                    array = String.format("[%d]", upper);
                }
            }
        }
        return array;
    }

    public static String modCVQualifier(Element element) {
        return Modifier.modCVQualifier(element, false);
    }

    public static String modCVQualifier(Element element, boolean isImplem) {
        Object modifier = EMPTY;
        if (!(element instanceof Operation) || !((Operation)element).isStatic()) {
            if (GenUtils.hasStereotype((Element)element, Const.class)) {
                modifier = StringUtils.append((String)modifier, (String)"const");
            }
            if (GenUtils.hasStereotype((Element)element, Volatile.class)) {
                modifier = StringUtils.append((String)modifier, (String)"volatile");
            }
        }
        if (GenUtils.hasStereotype((Element)element, Mutable.class) && element instanceof Property && !((Property)element).isStatic()) {
            modifier = StringUtils.append((String)modifier, (String)"mutable");
        }
        if (GenUtils.hasStereotype((Element)element, AOverride.class) && !isImplem && element instanceof Operation && !((Operation)element).isStatic()) {
            modifier = StringUtils.append((String)modifier, (String)"override");
        }
        if (((String)modifier).length() > 0) {
            modifier = element instanceof Operation ? " " + (String)modifier : (String)modifier + " ";
        }
        return modifier;
    }

    public static String modCEQualifier(Element propertyOrOperation) {
        if ((!(propertyOrOperation instanceof Property) || ((Property)propertyOrOperation).isStatic()) && GenUtils.hasStereotype((Element)propertyOrOperation, Constexpr.class)) {
            return "constexpr ";
        }
        return EMPTY;
    }

    public static String modSCQualifier(Element propertyOrParameter) {
        StorageClass sc = (StorageClass)UMLUtil.getStereotypeApplication((Element)propertyOrParameter, StorageClass.class);
        if (sc != null) {
            return sc.getStorageClass().getLiteral() + " ";
        }
        return EMPTY;
    }

    public static String dirInfo(Element propertyOperationOrParameter) {
        if (propertyOperationOrParameter instanceof Parameter) {
            ParameterDirectionKind directionKind = ((Parameter)propertyOperationOrParameter).getDirection();
            if (directionKind == ParameterDirectionKind.IN_LITERAL) {
                return " /*in*/";
            }
            if (directionKind == ParameterDirectionKind.OUT_LITERAL) {
                return " /*out*/";
            }
            if (directionKind == ParameterDirectionKind.INOUT_LITERAL) {
                return " /*inout*/";
            }
        }
        return EMPTY;
    }

    protected static boolean isReturn(Element propertyOrParameter) {
        if (propertyOrParameter instanceof Parameter) {
            return ((Parameter)propertyOrParameter).getDirection() == ParameterDirectionKind.RETURN_LITERAL;
        }
        return false;
    }

    public static void update(Element propertyOperationOrParameter) {
    }
}

