/**
 * Copyright (c) 2013 CEA LIST
 *
 * All rights reserved. This program and the accompanying materials are
 * made available under the terms of the Eclipse Public License 2.0 which
 * accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *    Ansgar Radermacher - Initial API and implementation
 *
 */
package org.eclipse.papyrus.designer.components.fcm.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.papyrus.designer.components.fcm.FCMPackage;
import org.eclipse.papyrus.designer.components.fcm.PortKind;
import org.eclipse.papyrus.designer.components.fcm.TemplatePort;
import org.eclipse.papyrus.designer.components.fcm.profile.utils.PortMapUtil;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Template Port</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.papyrus.designer.components.fcm.impl.TemplatePortImpl#getBoundType <em>Bound Type</em>}</li>
 * </ul>
 *
 * @generated
 */
public class TemplatePortImpl extends PortImpl implements TemplatePort {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TemplatePortImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return FCMPackage.Literals.TEMPLATE_PORT;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public PortKind getBoundType() {
		PortKind boundType = basicGetBoundType();
		return boundType != null && boundType.eIsProxy() ? (PortKind)eResolveProxy((InternalEObject)boundType) : boundType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PortKind basicGetBoundType() {
		// TODO: implement this method to return the 'Bound Type' reference
		// -> do not perform proxy resolution
		// Ensure that you remove @generated or mark it @generated NOT
		throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case FCMPackage.TEMPLATE_PORT__BOUND_TYPE:
				if (resolve) return getBoundType();
				return basicGetBoundType();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case FCMPackage.TEMPLATE_PORT__BOUND_TYPE:
				return basicGetBoundType() != null;
		}
		return super.eIsSet(featureID);
	}

} // TemplatePortImpl
