/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.utils;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.uml.tools.utils.Activator;
import org.eclipse.papyrus.uml.tools.utils.ImageUtil;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ElementImport;
import org.eclipse.uml2.uml.Image;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageImport;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLUtil;

public class ElementUtil {
    private static final String GETTER_SHAPE = "getShape";
    private static final String GETTER_ICON = "getIcon";
    private static final String SHAPE = "shape";
    private static final String ICON = "icon";

    @Deprecated
    public static EObject hasStereotype(Element elt, EClass stereotypeClass) {
        return UMLUtil.getStereotypeApplication((Element)elt, stereotypeClass.getClass());
    }

    @Deprecated
    public static <T extends EObject> T getStereotypeApplication(Element element, java.lang.Class<T> clazz) {
        return (T)UMLUtil.getStereotypeApplication((Element)element, clazz);
    }

    public static Image getStereotypeImage(Element element, Stereotype stereotype, String kind) {
        if (stereotype == null || element == null) {
            return null;
        }
        Image image = null;
        image = ElementUtil.getStereotypeImageFromGetter(element, stereotype, kind);
        if (image == null) {
            EList<Image> availableImages = new EList<Image>();
            if (ICON.equals(kind)) {
                availableImages = StereotypeUtil.getIcons(stereotype);
            } else if (SHAPE.equals(kind)) {
                availableImages = StereotypeUtil.getShapes(stereotype);
            }
            if (!availableImages.isEmpty() && (image = ImageUtil.findImageVerifyingExpression(element, availableImages)) == null) {
                image = (Image)availableImages.get(0);
            }
        }
        return image;
    }

    public static Image getStereotypeImage(Element element, String kind) {
        EList appliedStereotypes = element.getAppliedStereotypes();
        if (appliedStereotypes == null || appliedStereotypes.isEmpty()) {
            return null;
        }
        Stereotype stereotype = (Stereotype)appliedStereotypes.get(0);
        return ElementUtil.getStereotypeImage(element, stereotype, kind);
    }

    public static Image getStereotypeImageFromGetter(Element element, Stereotype stereotype, String kind) {
        Object getterName = "";
        if (ICON.equals(kind)) {
            getterName = (String)getterName + GETTER_ICON;
        } else if (SHAPE.equals(kind)) {
            getterName = (String)getterName + GETTER_SHAPE;
        } else {
            return null;
        }
        EObject stApp = element.getStereotypeApplication(stereotype);
        Method getter = null;
        try {
            getter = stApp.getClass().getDeclaredMethod((String)getterName, new java.lang.Class[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (getter != null) {
            try {
                Image image = (Image)getter.invoke((Object)stApp, new Object[0]);
                return image;
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public static boolean hasIcons(Element element) {
        EList appliedStereotypes = element.getAppliedStereotypes();
        if (!appliedStereotypes.isEmpty()) {
            return ElementUtil.hasIcons(element, (Stereotype)appliedStereotypes.get(0));
        }
        return false;
    }

    public static boolean hasIcons(Element element, Stereotype stereotype) {
        return stereotype != null && !StereotypeUtil.getIcons(stereotype).isEmpty();
    }

    public static boolean hasShapes(Element element) {
        EList appliedStereotypes = element.getAppliedStereotypes();
        if (!appliedStereotypes.isEmpty()) {
            return ElementUtil.hasShapes(element, (Stereotype)appliedStereotypes.get(0));
        }
        return false;
    }

    public static boolean hasShapes(Element element, Stereotype stereotype) {
        return stereotype != null && !StereotypeUtil.getShapes(stereotype).isEmpty();
    }

    public static List<Class> getPossibleMetaclasses(Element element) {
        ArrayList<Class> metaList = new ArrayList<Class>();
        List<Type> metaclasses = ElementUtil.getMetaclasses(element);
        int i = 0;
        while (i < metaclasses.size()) {
            if (metaclasses.get(i) instanceof Class) {
                metaList.add((Class)metaclasses.get(i));
            }
            ++i;
        }
        return metaList;
    }

    public static List<Type> getMetaclasses(Element element) {
        if (element == null) {
            Activator.log.warn("element should not be null to retrieve metaclasses");
            return Collections.emptyList();
        }
        Package uml2Metamodel = ElementUtil.contentload(URI.createURI((String)"pathmap://UML_METAMODELS/UML.metamodel.uml"), element);
        return uml2Metamodel.getOwnedTypes();
    }

    public static Package contentload(URI uri, Element element) {
        ResourceSet resourceSet = element.eResource().getResourceSet();
        Package package_ = null;
        try {
            Resource resource = resourceSet.getResource(uri, true);
            package_ = (Package)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)UMLPackage.eINSTANCE.getPackage());
        }
        catch (WrappedException we) {
            Activator.logError("impossible to load content for URI: " + String.valueOf(uri));
        }
        return package_;
    }

    public static final <T extends EObject> List<T> getInstancesFilteredByType(Package topPackage, java.lang.Class<T> metaType, Stereotype appliedStereotype) {
        TreeIterator iter = topPackage.eAllContents();
        ArrayList<EObject> filteredElements = new ArrayList<EObject>();
        while (iter.hasNext()) {
            Package importedPackage;
            EObject currentElt = (EObject)iter.next();
            if (currentElt instanceof ElementImport) {
                ElementImport elementImport = (ElementImport)currentElt;
                currentElt = elementImport.getImportedElement();
            } else if (currentElt instanceof PackageImport && (importedPackage = ((PackageImport)currentElt).getImportedPackage()) != null) {
                TreeIterator piIter = importedPackage.eAllContents();
                while (piIter.hasNext()) {
                    PackageableElement importedElement;
                    EObject piCurrentElt = (EObject)piIter.next();
                    if (!(piCurrentElt instanceof Element)) continue;
                    if (appliedStereotype != null) {
                        for (Stereotype currentSt : ((Element)piCurrentElt).getAppliedStereotypes()) {
                            if (!currentSt.conformsTo((Type)appliedStereotype)) continue;
                            filteredElements.add(piCurrentElt);
                        }
                        continue;
                    }
                    if (metaType.isInstance(piCurrentElt)) {
                        filteredElements.add(piCurrentElt);
                        continue;
                    }
                    if (!(piCurrentElt instanceof ElementImport) || (importedElement = ((ElementImport)piCurrentElt).getImportedElement()) == null) continue;
                    TreeIterator eIter = importedElement.eAllContents();
                    while (eIter.hasNext()) {
                        EObject currentEIelt = (EObject)eIter.next();
                        if (!metaType.isInstance(currentEIelt)) continue;
                        filteredElements.add(currentEIelt);
                    }
                }
            }
            if (!(currentElt instanceof Element)) continue;
            if (appliedStereotype != null) {
                for (Stereotype currentSt : ((Element)currentElt).getAppliedStereotypes()) {
                    if (!currentSt.conformsTo((Type)appliedStereotype)) continue;
                    filteredElements.add(currentElt);
                }
                continue;
            }
            if (metaType.isInstance(currentElt)) {
                filteredElements.add(currentElt);
                continue;
            }
            if (!(currentElt instanceof ElementImport)) continue;
            TreeIterator eIter = ((ElementImport)currentElt).getImportedElement().eAllContents();
            while (eIter.hasNext()) {
                EObject currentEIelt = (EObject)eIter.next();
                if (!metaType.isInstance(currentEIelt)) continue;
                filteredElements.add(currentEIelt);
            }
        }
        return filteredElements;
    }

    public static boolean hasStereotypeApplied(Element element, String stereotype) {
        List sourceAppliedStereotypes = element.getAppliedStereotypes().stream().map(st -> st.getQualifiedName()).collect(Collectors.toList());
        sourceAppliedStereotypes.addAll(element.getAppliedStereotypes().stream().flatMap(st -> st.allParents().stream()).filter(Stereotype.class::isInstance).map(Stereotype.class::cast).map(st -> st.getQualifiedName()).collect(Collectors.toList()));
        return sourceAppliedStereotypes.contains(stereotype);
    }
}

