/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.ui.tracepoint.view;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.actions.ExportBreakpointsOperation;
import org.eclipse.papyrus.moka.ui.tracepoint.view.Activator;
import org.eclipse.papyrus.moka.ui.tracepoint.view.ImportTracepointsOperation;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;

public class ImportExportTPs {
    public static final String DOT_UML = ".uml";
    public static final String DOT_TPOINTS = ".tpoints";
    public static final String TRACEPOINT_FILES = "Tracepoint files";

    public static void importTracepoints() {
        try {
            IEditorPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            IFile file = null;
            if (part.getEditorInput() instanceof IFileEditorInput) {
                file = ((IFileEditorInput)part.getEditorInput()).getFile();
            }
            String defaultDir = file != null ? FileLocator.resolve((URL)file.getParent().getLocationURI().toURL()).getFile() : ResourcesPlugin.getWorkspace().getRoot().getLocation().toString();
            Shell shell = Display.getCurrent().getActiveShell();
            FileDialog fd = new FileDialog(shell, 4096);
            fd.setText("Import Tracepoints");
            String[] filterExt = new String[]{"*.tpoints"};
            String[] filterNames = new String[]{TRACEPOINT_FILES};
            fd.setFilterExtensions(filterExt);
            fd.setFilterPath(defaultDir);
            fd.setFilterNames(filterNames);
            String fileName = fd.open();
            if (fileName != null) {
                ImportTracepointsOperation importAction = new ImportTracepointsOperation(fileName);
                importAction.run((IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (InvocationTargetException e) {
            Activator.getDefault().logger.error("Error occured while running import action", (Throwable)e);
        }
        catch (IOException e) {
            Activator.getDefault().logger.error("Error occured while resolving file to import", (Throwable)e);
        }
    }

    public static void exportTracepoints(List<IBreakpoint> tracepoints) {
        if (tracepoints.size() > 0) {
            try {
                IBreakpoint[] tracepArray = tracepoints.toArray(new IBreakpoint[0]);
                IBreakpoint firstTP = tracepoints.get(0);
                IResource resource = firstTP.getMarker().getResource();
                String defaultFN = resource.getName().replace(DOT_UML, DOT_TPOINTS);
                String defaultDir = FileLocator.resolve((URL)resource.getParent().getLocationURI().toURL()).getFile();
                Shell shell = Display.getCurrent().getActiveShell();
                FileDialog fd = new FileDialog(shell, 8192);
                fd.setText("Export Tracepoints");
                String[] filterExt = new String[]{"*.tpoints"};
                String[] filterNames = new String[]{TRACEPOINT_FILES};
                fd.setFilterExtensions(filterExt);
                fd.setFileName(defaultFN);
                fd.setFilterPath(defaultDir);
                fd.setFilterNames(filterNames);
                String fileName = fd.open();
                if (fileName != null) {
                    ExportBreakpointsOperation exportAction = new ExportBreakpointsOperation(tracepArray, fileName);
                    exportAction.run((IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (InvocationTargetException e) {
                Activator.getDefault().logger.error("Error occured while running export action", (Throwable)e);
            }
            catch (IOException e) {
                Activator.getDefault().logger.error("Error occured while resolving file to export", (Throwable)e);
            }
        }
    }
}

